SetGrainFlapEvent = {};
SetGrainFlapEvent_mt = Class(SetGrainFlapEvent, Event);

InitEventClass(SetGrainFlapEvent, "SetGrainFlapEvent");

function SetGrainFlapEvent:emptyNew()
    local self = Event:new(SetGrainFlapEvent_mt);
    self.className="SetGrainFlapEvent";
    return self;
end;

function SetGrainFlapEvent:new(vehicle, grainFlapState)
    local self = SetGrainFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.grainFlapState = grainFlapState;
    return self;
end;

function SetGrainFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.grainFlapState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetGrainFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.grainFlapState);
end;

function SetGrainFlapEvent:run(connection)
	self.vehicle:SetGrainFlap(self.grainFlapState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetGrainFlapEvent:new(self.vehicle, self.grainFlapState), nil, connection, self.vehicle);
    end;
end;

function SetGrainFlapEvent.sendEvent(vehicle, grainFlapState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetGrainFlapEvent:new(vehicle, grainFlapState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetGrainFlapEvent:new(vehicle, grainFlapState));
		end;
	end;
end;