--
-- ManualAttaching script
-- author: Burner
-- date: 01.06.2012
--

steerable_update = Steerable.update;
attachable_update = Attachable.update;

ManualAttachingFunction = function(self, dt)
	if not self:getIsActiveForInput() then
		for j=1, table.getn(self.attacherJoints) do
			local jointDesc = self.attacherJoints[j];
			local px, py, pz = getWorldTranslation(jointDesc.jointTransform);
			for k, attachable in pairs(g_currentMission.attachables) do
				local attacherJoint = attachable.attacherJoint;
				if attachable.attacherVehicle == nil and attacherJoint.jointType == jointDesc.jointType then
					local vx, vy, vz = getWorldTranslation(attacherJoint.node);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					local nearestDistance = 2;
					if distance < nearestDistance then
						if g_currentMission.player ~= nil then
							local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
							local farmerDistance = Utils.vector3Length(pvx-px, pvy-py, pvz-pz);
							if farmerDistance < nearestDistance then
								g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Attach"), self.typeDesc), InputBinding.ATTACH);
								if InputBinding.hasEvent(InputBinding.ATTACH) then
									self:attachImplement(attachable, j);
									self:playAttachSound();
								end;
							end;
						end;
					end;
				elseif attachable.attacherVehicle == self and attacherJoint.jointType == jointDesc.jointType then
					local vx, vy, vz = getWorldTranslation(attacherJoint.node);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					local nearestDistance = 2;
					if distance < nearestDistance then
						if g_currentMission.player ~= nil then
							local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
							local farmerDistance = Utils.vector3Length(pvx-px, pvy-py, pvz-pz);
							if farmerDistance < nearestDistance then
								for i=1, table.getn(self.attachedImplements) do
									if self.attachedImplements[i].object == attachable then
										g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Detach"), self.typeDesc), InputBinding.ATTACH);
										if InputBinding.hasEvent(InputBinding.ATTACH) then
											self:detachImplement(i);
											self:playDetachSound();
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
		
		for k, implement in pairs(self.attachedImplements) do
			local jointDesc = self.attacherJoints[implement.jointDescIndex];
			local attacherJoint = implement.object.attacherJoint;
			if jointDesc.topArm ~= nil and attacherJoint.topReferenceNode ~= nil then
				local ax, ay, az = getWorldTranslation(jointDesc.topArm.rotationNode);
				local bx, by, bz = getWorldTranslation(attacherJoint.topReferenceNode);

				local x, y, z = worldDirectionToLocal(getParent(jointDesc.topArm.rotationNode), bx-ax, by-ay, bz-az);
				local upX, upY, upZ = 0,1,0;
				if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
					-- direction and up is parallel
					upY = 0;
					if y > 0 then
						upZ = 1;
					else
						upZ = -1;
					end;
				end;
	  
				setDirection(jointDesc.topArm.rotationNode, x*jointDesc.topArm.zScale, y*jointDesc.topArm.zScale, z*jointDesc.topArm.zScale, upX, upY, upZ);
				if jointDesc.topArm.translationNode ~= nil then
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					setTranslation(jointDesc.topArm.translationNode, 0, 0, (distance-jointDesc.topArm.referenceDistance)*jointDesc.topArm.zScale);
				end;
			end;
			if jointDesc.bottomArm ~= nil then
				local ax, ay, az = getWorldTranslation(jointDesc.bottomArm.rotationNode);
				local bx, by, bz = getWorldTranslation(attacherJoint.node);
	  
				local x, y, z = worldDirectionToLocal(getParent(jointDesc.bottomArm.rotationNode), bx-ax, by-ay, bz-az);
				local upX, upY, upZ = 0,1,0;
				if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
					-- direction and up is parallel
					upY = 0;
					if y > 0 then
						upZ = 1;
					else
						upZ = -1;
					end;
				end;
				setDirection(jointDesc.bottomArm.rotationNode, x*jointDesc.bottomArm.zScale, y*jointDesc.bottomArm.zScale, z*jointDesc.bottomArm.zScale, upX, upY, upZ);
				if jointDesc.bottomArm.translationNode ~= nil then
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					setTranslation(jointDesc.bottomArm.translationNode, 0, 0, (distance-jointDesc.bottomArm.referenceDistance)*jointDesc.bottomArm.zScale);
				end;
			end;
		end;
	end;
end;

Steerable.update = function(self, dt)
	steerable_update(self, dt);
	ManualAttachingFunction(self, dt);
end;

Attachable.update = function(self, dt)
	attachable_update(self, dt);
	ManualAttachingFunction(self, dt);
end;