SetMowerOnEvent = {};
SetMowerOnEvent_mt = Class(SetMowerOnEvent, Event);
  
InitEventClass(SetMowerOnEvent, "SetMowerOnEvent");
  
function SetMowerOnEvent:emptyNew()
     local self = Event:new(SetMowerOnEvent_mt);
      self.className="SetMowerOnEvent";
      return self;
end;
  
function SetMowerOnEvent:new(object, mowerOn)
      local self = SetMowerOnEvent:emptyNew()
      self.object = object;
      self.mowerOn = mowerOn;
      return self;
end;
  
function SetMowerOnEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.mowerOn = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetMowerOnEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.mowerOn);
end;
  
function SetMowerOnEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsMowerOn(self.mowerOn, true);
end;
  
function SetMowerOnEvent.sendEvent(vehicle, mowerOn, noEventSend)
      if mowerOn ~= vehicle.isMowerOn then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetMowerOnEvent:new(vehicle, mowerOn), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetMowerOnEvent:new(vehicle, mowerOn));
              end;
          end;
      end;
end;