-- 
-- Scrypt do przyczepy D-50 by maciusboss1
-- Scrypt by maciusboss1
-- Data: 27.07.2011 r.
-- Zakaz przerabiania i brania do swoich modeli
-- Zapraszam na www.lsmodss.pl


D50 = {};

function D50.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function D50:load(xmlFile)

	
	    self.plandeka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka#index"));
        self.plandekaActive = false;
        self.plandeka1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka1#index"));
        self.changeTools = SpecializationUtil.callSpecializationsFunction("changeTools");
		self.objectInRange = D50.objectInRange;
		self.plandeka2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka2#index"));
		self.zamontujPlandeka2 = SpecializationUtil.callSpecializationsFunction("zamontujPlandeka2");
		self.plandeka2Active = false;


end;

function D50:readStream(streamId, connection)
	self:changeTools(streamReadBool(streamId), true);
	self:zamontujPlandeka2(streamReadBool(streamId), true);
end;

function D50:writeStream(streamId, connection)
	streamWriteBool(streamId, self.plandekaActive);
	streamWriteBool(streamId, self.plandeka2Active);
end;

function D50:delete()
end;

function D50:mouseEvent(posX, posY, isDown, isUp, button)
end;

function D50:keyEvent(unicode, sym, modifier, isDown)
end;

function D50:update(dt)

	if self.plandeka ~= nil then
		setVisibility(self.plandeka, self.plandekaActive);
	end;
	if self.plandeka1 ~= nil then
		setVisibility(self.plandeka1, not self.plandekaActive);
	end;
	
	if self.isClient then
		if self:objectInRange(self.plandeka) then
			if InputBinding.hasEvent(InputBinding.D50_Plandeka) then
				self:changeTools(not self.plandekaActive);
			end;
			if self.plandekaActive then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZDEJMIJ_PLANDEKE")), InputBinding.D50_Plandeka);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZALOZ_PLANDEKE")), InputBinding.D50_Plandeka);
			end;
		end;
		
			if self:objectInRange(self.animationParts[1].rootNode) then
			if InputBinding.hasEvent(InputBinding.D50_BURTAP) then
				if self.animationParts[1].clipEndTime then
					self:setAnimationTime(1, self.animationParts[1].offSet);
				elseif self.animationParts[1].clipStartTime then
					self:setAnimationTime(1, self.animationParts[1].animDuration);
				end;
			end;
			if self.animationParts[1].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZAMKNIJ_BURTE")), InputBinding.D50_BURTAP);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_OTWORZ_BURTE")), InputBinding.D50_BURTAP);
			end;
		end;
		if self:objectInRange(self.animationParts[2].rootNode) then
			if InputBinding.hasEvent(InputBinding.D50_BURTAL) then
				if self.animationParts[2].clipEndTime then
					self:setAnimationTime(2, self.animationParts[2].offSet);
				elseif self.animationParts[2].clipStartTime then
					self:setAnimationTime(2, self.animationParts[2].animDuration);
				end;
			end;
			if self.animationParts[2].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZAMKNIJ_BURTE")), InputBinding.D50_BURTAL);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_OTWORZ_BURTE")), InputBinding.D50_BURTAL);
			end;
		end;
		
    	if self:objectInRange(self.plandeka2) then
			if InputBinding.hasEvent(InputBinding.D50_PLANDEKA2) then
				self:zamontujPlandeka2(not self.plandeka2Active);
			end;
			if self.plandeka2Active then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZDEMONTUJ_PLANDEKE")), InputBinding.D50_PLANDEKA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D50_ZAMONTUJ_PLANDEKE")), InputBinding.D50_PLANDEKA2);
			end;
		end;
	end;

	if self.plandeka2 ~= nil then
		setVisibility(self.plandeka2, self.plandeka2Active);
	end;


end;

function D50:draw()
end;


function D50:onAttach()
	
end;

function D50:onDetach()
end;

function D50:onLeave()
end;

function D50:changeTools(plandekaStatus,noEventSend)
	ChangeToolsEvent.sendEvent(self, plandekaStatus, noEventSend);
	self.plandekaActive = plandekaStatus;
end;

function D50:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 4;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function D50:zamontujPlandeka2(plandeka2Active,noEventSend)
	ZamontujPlandeka2Event.sendEvent(self, plandeka2Active, noEventSend);
	self.plandeka2Active = plandeka2Active;
end;