--
-- skrypt na worki
-- autor: Burner
--

Bags = {};

function Bags.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Bags:load(xmlFile)
	self.bagsFillTypes = {};
	self.bagsFillTypes[Fillable.FILLTYPE_UNKNOWN] = true;
	local bagsFillTypes = getXMLString(xmlFile, "vehicle.bagsFillTypes#fruitTypes");
	if bagsFillTypes ~= nil then
		local types = Utils.splitString(" ", bagsFillTypes);
		for k,v in pairs(types) do
			local bagsFillType = Fillable.fillTypeNameToInt[v];
			if bagsFillType ~= nil then
				self.bagsFillTypes[bagsFillType] = true;
			else
				--print("Warning: '"..self.configFileName.. "' has invalid fillType '"..v.."'.");
			end;
		end;
	end;

    local bagsIndex = getXMLString(xmlFile, "vehicle.bags#index");
    self.bagsCount = getXMLInt(xmlFile, "vehicle.bags#count");
    self.bagsRootNode = Utils.indexToObject(self.components, bagsIndex);
end;

function Bags:delete()
end;

function Bags:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bags:keyEvent(unicode, sym, modifier, isDown)
end;

function Bags:update(dt)
	setVisibility(self.bagsRootNode, true); 
	for i=1, self.bagsCount do
		local worek = getChildAt(self.bagsRootNode, i-1);
		setVisibility(worek, false);
	end;
	percentDecimal = self.fillLevel/self.capacity;
	self.bagsToShow = math.ceil(self.bagsCount*percentDecimal);
	
	for k,v in pairs(self.bagsFillTypes) do
		if k ~= Fillable.FILLTYPE_UNKNOWN and v and k == self.currentFillType then
			for i=1, self.bagsToShow do
				local worek = getChildAt(self.bagsRootNode, i-1);
				setVisibility(worek, true);
			end;
		end;
	end;
end;

function Bags:draw()
end;