--
-- Lua for Mini_Mini_Map by usxi7sd
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Mini_Mini_Map = {}

local Mini_Mini_Map_mt = Class(Mini_Mini_Map, Mission00);

function Mini_Mini_Map:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Mini_Mini_Map_mt;
    end;
    local self = Mini_Mini_Map:superClass():new(baseDirectory, mt);
    return self;
end;

function Mini_Mini_Map:delete()
    Mini_Mini_Map:superClass().delete(self);
end;

function Mini_Mini_Map:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));  

	-- Milch und Manureproduktionsbeschraenkung --
	g_currentMission.milkProductionScale = 0.5;
	--print(" --Info: Mini_Mini_Map milkProductionScale = 0.1");    
    g_currentMission.manureProductionScale = 0.5;
	--print(" --Info: Mini_Mini_Map manureProductionScale = 0.2");
  --g_currentMission.milkPriceScale = 0.1;
	--print(" --Info: Mini_Mini_Map milkPriceScale = 0.1");
	
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory)); 
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));    
    Mini_Mini_Map:superClass().load(self);
end
function Mini_Mini_Map:loadFinished()
    Mini_Mini_Map:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Mini_Mini_Map:mouseEvent(posX, posY, isDown, isUp, button)
    Mini_Mini_Map:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;
function Mini_Mini_Map:keyEvent(unicode, sym, modifier, isDown)
    Mini_Mini_Map:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;
function Mini_Mini_Map:update(dt)
    Mini_Mini_Map:superClass().update(self, dt);
end;
function Mini_Mini_Map:draw()
    Mini_Mini_Map:superClass().draw(self);
end;