--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
	    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	
	bgapic = Utils.getFilename("Meyenburg/pdasymbols/bga.png", self.baseDirectory);
	biopic = Utils.getFilename("Meyenburg/pdasymbols/bio.png", self.baseDirectory);
	cafepic = Utils.getFilename("Meyenburg/pdasymbols/cafe.png", self.baseDirectory);
	dlc3pic = Utils.getFilename("Meyenburg/pdasymbols/dlc3.png", self.baseDirectory);
	einkaufswagenpic = Utils.getFilename("dataS2/missions/hud_pda_spot_mall.png", self.baseDirectory);
	mzgpic = Utils.getFilename("Meyenburg/pdasymbols/mzg.png", self.baseDirectory);
	genossenschaftpic = Utils.getFilename("Meyenburg/pdasymbols/genossenschaft.png", self.baseDirectory);
	jansenpic = Utils.getFilename("Meyenburg/pdasymbols/jansen.png", self.baseDirectory);
	kirchepic = Utils.getFilename("dataS2/missions/hud_pda_spot_bell.png", self.baseDirectory);
	kuehepic = Utils.getFilename("dataS2/missions/hud_pda_spot_cow.png", self.baseDirectory);
	mattfeldpic = Utils.getFilename("Meyenburg/pdasymbols/mattfeld.png", self.baseDirectory);
	rittergutpic = Utils.getFilename("dataS2/missions/hud_pda_spot_ruin.png", self.baseDirectory);
	ritterguttextpic = Utils.getFilename("Meyenburg/pdasymbols/ritterguttext.png", self.baseDirectory);
	shoppic = Utils.getFilename("dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory);
	steilenpic = Utils.getFilename("Meyenburg/pdasymbols/steilen.png", self.baseDirectory);
	wasserradpic = Utils.getFilename("dataS2/missions/hud_pda_spot_watermill.png", self.baseDirectory);
	wasserwerkpic = Utils.getFilename("Meyenburg/pdasymbols/wasserwerk.png", self.baseDirectory);
	einspic = Utils.getFilename("Meyenburg/pdasymbols/eins.png", self.baseDirectory);
	zweipic = Utils.getFilename("Meyenburg/pdasymbols/zwei.png", self.baseDirectory);
	dreipic = Utils.getFilename("Meyenburg/pdasymbols/drei.png", self.baseDirectory);
	vierpic = Utils.getFilename("Meyenburg/pdasymbols/vier.png", self.baseDirectory);
	fuenfpic = Utils.getFilename("Meyenburg/pdasymbols/fuenf.png", self.baseDirectory);
	sechspic = Utils.getFilename("Meyenburg/pdasymbols/sechs.png", self.baseDirectory);
	siebenpic = Utils.getFilename("Meyenburg/pdasymbols/sieben.png", self.baseDirectory);
	achtpic = Utils.getFilename("Meyenburg/pdasymbols/acht.png", self.baseDirectory);
	neunpic = Utils.getFilename("Meyenburg/pdasymbols/neun.png", self.baseDirectory);
	einsnullpic = Utils.getFilename("Meyenburg/pdasymbols/einsnull.png", self.baseDirectory);
	einseinspic = Utils.getFilename("Meyenburg/pdasymbols/einseins.png", self.baseDirectory);
	einszweipic = Utils.getFilename("Meyenburg/pdasymbols/einszwei.png", self.baseDirectory);
	einsdreipic = Utils.getFilename("Meyenburg/pdasymbols/einsdrei.png", self.baseDirectory);
	einsvierpic = Utils.getFilename("Meyenburg/pdasymbols/einsvier.png", self.baseDirectory);
	einsfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/einsfuenf.png", self.baseDirectory);
	einssechspic = Utils.getFilename("Meyenburg/pdasymbols/einssechs.png", self.baseDirectory);
	einssiebenpic = Utils.getFilename("Meyenburg/pdasymbols/einssieben.png", self.baseDirectory);
	einsachtpic = Utils.getFilename("Meyenburg/pdasymbols/einsacht.png", self.baseDirectory);
	einsneunpic = Utils.getFilename("Meyenburg/pdasymbols/einsneun.png", self.baseDirectory);
	zweinullpic = Utils.getFilename("Meyenburg/pdasymbols/zweinull.png", self.baseDirectory);
	zweieinspic = Utils.getFilename("Meyenburg/pdasymbols/zweieins.png", self.baseDirectory);
	zweizweipic = Utils.getFilename("Meyenburg/pdasymbols/zweizwei.png", self.baseDirectory);
	zweidreipic = Utils.getFilename("Meyenburg/pdasymbols/zweidrei.png", self.baseDirectory);
	zweivierpic = Utils.getFilename("Meyenburg/pdasymbols/zweivier.png", self.baseDirectory);
	zweifuenfpic = Utils.getFilename("Meyenburg/pdasymbols/zweifuenf.png", self.baseDirectory);
	zweisechspic = Utils.getFilename("Meyenburg/pdasymbols/zweisechs.png", self.baseDirectory);
	zweisiebenpic = Utils.getFilename("Meyenburg/pdasymbols/zweisieben.png", self.baseDirectory);
	zweiachtpic = Utils.getFilename("Meyenburg/pdasymbols/zweiacht.png", self.baseDirectory);
	zweineunpic = Utils.getFilename("Meyenburg/pdasymbols/zweineun.png", self.baseDirectory);
	dreinullpic = Utils.getFilename("Meyenburg/pdasymbols/dreinull.png", self.baseDirectory);
	dreieinspic = Utils.getFilename("Meyenburg/pdasymbols/dreieins.png", self.baseDirectory);
	dreizweipic = Utils.getFilename("Meyenburg/pdasymbols/dreizwei.png", self.baseDirectory);
	dreidreipic = Utils.getFilename("Meyenburg/pdasymbols/dreidrei.png", self.baseDirectory);
	dreivierpic = Utils.getFilename("Meyenburg/pdasymbols/dreivier.png", self.baseDirectory);
	dreifuenfpic = Utils.getFilename("Meyenburg/pdasymbols/dreifuenf.png", self.baseDirectory);
	dreisechspic = Utils.getFilename("Meyenburg/pdasymbols/dreisechs.png", self.baseDirectory);
	dreisiebenpic = Utils.getFilename("Meyenburg/pdasymbols/dreisieben.png", self.baseDirectory);
	dreiachtpic = Utils.getFilename("Meyenburg/pdasymbols/dreiacht.png", self.baseDirectory);
	dreineunpic = Utils.getFilename("Meyenburg/pdasymbols/dreineun.png", self.baseDirectory);
	viernullpic = Utils.getFilename("Meyenburg/pdasymbols/viernull.png", self.baseDirectory);
	viereinspic = Utils.getFilename("Meyenburg/pdasymbols/viereins.png", self.baseDirectory);
	vierzweipic = Utils.getFilename("Meyenburg/pdasymbols/vierzwei.png", self.baseDirectory);
	vierdreipic = Utils.getFilename("Meyenburg/pdasymbols/vierdrei.png", self.baseDirectory);
	viervierpic = Utils.getFilename("Meyenburg/pdasymbols/viervier.png", self.baseDirectory);
	vierfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/vierfuenf.png", self.baseDirectory);
	viersechspic = Utils.getFilename("Meyenburg/pdasymbols/viersechs.png", self.baseDirectory);
	viersiebenpic = Utils.getFilename("Meyenburg/pdasymbols/viersieben.png", self.baseDirectory);
	vierachtpic = Utils.getFilename("Meyenburg/pdasymbols/vieracht.png", self.baseDirectory);
	vierneunpic = Utils.getFilename("Meyenburg/pdasymbols/vierneun.png", self.baseDirectory);
	fuenfnullpic = Utils.getFilename("Meyenburg/pdasymbols/fuenfnull.png", self.baseDirectory);
	fuenfeinspic = Utils.getFilename("Meyenburg/pdasymbols/fuenfeins.png", self.baseDirectory);
	fuenfzweipic = Utils.getFilename("Meyenburg/pdasymbols/fuenfzwei.png", self.baseDirectory);
	fuenfdreipic = Utils.getFilename("Meyenburg/pdasymbols/fuenfdrei.png", self.baseDirectory);
	fuenfvierpic = Utils.getFilename("Meyenburg/pdasymbols/fuenfvier.png", self.baseDirectory);
	fuenffuenfpic = Utils.getFilename("Meyenburg/pdasymbols/fuenffuenf.png", self.baseDirectory);
	fuenfsechspic = Utils.getFilename("Meyenburg/pdasymbols/fuenfsechs.png", self.baseDirectory);
	fuenfsiebenpic = Utils.getFilename("Meyenburg/pdasymbols/fuenfsieben.png", self.baseDirectory);
	fuenfachtpic = Utils.getFilename("Meyenburg/pdasymbols/fuenfacht.png", self.baseDirectory);
	fuenfneunpic = Utils.getFilename("Meyenburg/pdasymbols/fuenfneun.png", self.baseDirectory);
	sechsnullpic = Utils.getFilename("Meyenburg/pdasymbols/sechsnull.png", self.baseDirectory);
	sechseinspic = Utils.getFilename("Meyenburg/pdasymbols/sechseins.png", self.baseDirectory);
	sechszweipic = Utils.getFilename("Meyenburg/pdasymbols/sechszwei.png", self.baseDirectory);
	sechsdreipic = Utils.getFilename("Meyenburg/pdasymbols/sechsdrei.png", self.baseDirectory);
	sechsvierpic = Utils.getFilename("Meyenburg/pdasymbols/sechsvier.png", self.baseDirectory);
	sechsfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/sechsfuenf.png", self.baseDirectory);
	sechssechspic = Utils.getFilename("Meyenburg/pdasymbols/sechssechs.png", self.baseDirectory);
	sechssiebenpic = Utils.getFilename("Meyenburg/pdasymbols/sechssieben.png", self.baseDirectory);
	sechsachtpic = Utils.getFilename("Meyenburg/pdasymbols/sechsacht.png", self.baseDirectory);
	sechsneunpic = Utils.getFilename("Meyenburg/pdasymbols/sechsneun.png", self.baseDirectory);
	siebennullpic = Utils.getFilename("Meyenburg/pdasymbols/siebennull.png", self.baseDirectory);
	siebeneinspic = Utils.getFilename("Meyenburg/pdasymbols/siebeneins.png", self.baseDirectory);
	siebenzweipic = Utils.getFilename("Meyenburg/pdasymbols/siebenzwei.png", self.baseDirectory);
	siebendreipic = Utils.getFilename("Meyenburg/pdasymbols/siebendrei.png", self.baseDirectory);
	siebenvierpic = Utils.getFilename("Meyenburg/pdasymbols/siebenvier.png", self.baseDirectory);
	siebenfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/siebenfuenf.png", self.baseDirectory);
	siebensechspic = Utils.getFilename("Meyenburg/pdasymbols/siebensechs.png", self.baseDirectory);
	siebensiebenpic = Utils.getFilename("Meyenburg/pdasymbols/siebensieben.png", self.baseDirectory);
	siebenachtpic = Utils.getFilename("Meyenburg/pdasymbols/siebenacht.png", self.baseDirectory);
	siebenneunpic = Utils.getFilename("Meyenburg/pdasymbols/siebenneun.png", self.baseDirectory);
	achtnullpic = Utils.getFilename("Meyenburg/pdasymbols/achtnull.png", self.baseDirectory);
	achteinspic = Utils.getFilename("Meyenburg/pdasymbols/achteins.png", self.baseDirectory);
	achtzweipic = Utils.getFilename("Meyenburg/pdasymbols/achtzwei.png", self.baseDirectory);
	achtdreipic = Utils.getFilename("Meyenburg/pdasymbols/achtdrei.png", self.baseDirectory);
	achtvierpic = Utils.getFilename("Meyenburg/pdasymbols/achtvier.png", self.baseDirectory);
	achtfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/achtfuenf.png", self.baseDirectory);
	achtsechspic = Utils.getFilename("Meyenburg/pdasymbols/achtsechs.png", self.baseDirectory);
	achtsiebenpic = Utils.getFilename("Meyenburg/pdasymbols/achtsieben.png", self.baseDirectory);
	achtachtpic = Utils.getFilename("Meyenburg/pdasymbols/achtacht.png", self.baseDirectory);
	achtneunpic = Utils.getFilename("Meyenburg/pdasymbols/achtneun.png", self.baseDirectory);
	neunnullpic = Utils.getFilename("Meyenburg/pdasymbols/neunnull.png", self.baseDirectory);
	neuneinspic = Utils.getFilename("Meyenburg/pdasymbols/neuneins.png", self.baseDirectory);
	neunzweipic = Utils.getFilename("Meyenburg/pdasymbols/neunzwei.png", self.baseDirectory);
	neundreipic = Utils.getFilename("Meyenburg/pdasymbols/neundrei.png", self.baseDirectory);
	neunvierpic = Utils.getFilename("Meyenburg/pdasymbols/neunvier.png", self.baseDirectory);
	neunfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/neunfuenf.png", self.baseDirectory);
	neunsechspic = Utils.getFilename("Meyenburg/pdasymbols/neunsechs.png", self.baseDirectory);
	neunsiebenpic = Utils.getFilename("Meyenburg/pdasymbols/neunsieben.png", self.baseDirectory);
	neunachtpic = Utils.getFilename("Meyenburg/pdasymbols/neunacht.png", self.baseDirectory);
	neunneunpic = Utils.getFilename("Meyenburg/pdasymbols/neunneun.png", self.baseDirectory);
	einsnullnullpic = Utils.getFilename("Meyenburg/pdasymbols/einsnullnull.png", self.baseDirectory);
	einsnulleinspic = Utils.getFilename("Meyenburg/pdasymbols/einsnulleins.png", self.baseDirectory);
	einsnullzweipic = Utils.getFilename("Meyenburg/pdasymbols/einsnullzwei.png", self.baseDirectory);
	einsnulldreipic = Utils.getFilename("Meyenburg/pdasymbols/einsnulldrei.png", self.baseDirectory);
	einsnullvierpic = Utils.getFilename("Meyenburg/pdasymbols/einsnullvier.png", self.baseDirectory);
	einsnullfuenfpic = Utils.getFilename("Meyenburg/pdasymbols/einsnullfuenf.png", self.baseDirectory);
	einsnullsechspic = Utils.getFilename("Meyenburg/pdasymbols/einsnullsechs.png", self.baseDirectory);
	einsnullsiebenpic = Utils.getFilename("Meyenburg/pdasymbols/einsnullsieben.png", self.baseDirectory);
	
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("bga", bgapic, 529, 613, 0.036, 0.036, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("gaertnerei", biopic, 929, 318, 0.040, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Muehlencafe", cafepic, 1560, 348, 0.040, 0.040, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Genossenschaft", genossenschaftpic, 1218, 853, 0.040, 0.040, false, false, 0);
		
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Solarpark", dlc3pic, 50, 197, 0.036, 0.036, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("edeka", "dataS2/missions/hud_pda_spot_mall.png", 994, 867, 0.036, 0.036, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("jansen", jansenpic, 386, 1638, 0.040, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("kirche", "dataS2/missions/hud_pda_spot_bell.png", 707, 675, 0.036, 0.036, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("kuehe", "dataS2/missions/hud_pda_spot_cow.png",  550, 491, 0.036, 0.036, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Mattfeld", mattfeldpic, 1400, 807, 0.040, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("rittergut", "dataS2/missions/hud_pda_spot_ruin.png", 715, 341, 0.036, 0.036, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("ritterguttext", ritterguttextpic, 655, 280, 0.040, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Haendler", "dataS2/missions/hud_pda_spot_shop.png", 900, 1214, 0.025, 0.025, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("MZG", mzgpic, 1993, 1984, 0.060, 0.060, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Steilen", steilenpic, 600, 560, 0.050, 0.050, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Wassermuehle", "dataS2/missions/hud_pda_spot_watermill.png", 1487, 458, 0.025, 0.025, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Wasserwerk", wasserwerkpic, 921, 1619, 0.036, 0.036, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld1", einspic, 1024, 130, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld2", zweipic, 1044, 432, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld3", dreipic, 1175, 407, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld4", vierpic, 1298, 409, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld5", fuenfpic, 1445, 386, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld6", sechspic, 1611, 253, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld7", siebenpic, 1410, 643, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld8", achtpic, 1267, 654, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld9", neunpic, 1594, 678, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld10", einsnullpic, 1603, 780, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld11", einseinspic, 1549, 1069, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld12", einszweipic, 1670, 1180, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld13", einsdreipic, 1594, 1272, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld14", einsvierpic, 1433, 1006, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld15", einsfuenfpic, 1294, 960, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld16", einssechspic, 1294, 1034, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld17", einssiebenpic, 1375, 1140, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld18", einsachtpic, 1287, 1285, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld19", einsneunpic, 1380, 1287, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld20", zweinullpic, 1472, 1297, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld21", zweieinspic, 1164, 923, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld22", zweizweipic, 1130, 1002, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld23", zweidreipic, 1130, 1089, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld24", zweivierpic, 1130, 1166, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld25", zweifuenfpic, 1130, 1279, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld26", zweisechspic, 1140, 1399, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld27", zweisiebenpic, 1140, 1513, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld28", zweiachtpic, 1100, 1593, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld29", zweineunpic, 1310, 1462, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld30", dreinullpic, 1423, 1462, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld31", dreieinspic, 1465, 1592, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld32", dreizweipic, 1355, 1614, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld33", dreidreipic, 1355, 1731, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld34", dreivierpic, 1260, 1680, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld35", dreifuenfpic, 1151, 1680, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld36", dreisechspic, 1290, 1857, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld37", dreisiebenpic, 1211, 1857, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld38", dreiachtpic, 1189, 1979, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld39", dreineunpic, 1078, 1979, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld40", viernullpic, 968, 1979, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld41", viereinspic, 867, 1979, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld42", vierzweipic, 1119, 1875, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld43", vierdreipic, 1027, 1875, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld44", viervierpic, 950, 1859, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld45", vierfuenfpic, 1063, 1780, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld46", viersechspic, 1005, 1757, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld47", viersiebenpic, 910, 1699, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld48", vierachtpic, 833, 1775, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld49", vierneunpic, 795, 1901, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld50", fuenfnullpic, 721, 1821, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld51", fuenfeinspic, 671, 1869, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld52", fuenfzweipic, 636, 1924, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld53", fuenfdreipic, 490, 1853, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld54", fuenfvierpic, 480, 1929, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld55", fuenffuenfpic, 284, 1838, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld56", fuenfsechspic, 251, 1956, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld57", fuenfsiebenpic, 106, 1863, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld58", fuenfachtpic, 243, 1703, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld59", fuenfneunpic, 244, 1540, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld60", sechsnullpic, 107, 1618, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld61", sechseinspic, 119, 1450, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld62", sechszweipic, 119, 1387, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld63", sechsdreipic, 108, 1288, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld64", sechsvierpic, 190, 1266, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld65", sechsfuenfpic, 167, 1171, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld66", sechssechspic, 274, 1414, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld67", sechssiebenpic, 461, 1588, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld68", sechsachtpic, 498, 1527, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld69", sechsneunpic, 534, 1458, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld70", siebennullpic, 337, 1359, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld71", siebeneinspic, 366, 1287, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld72", siebenzweipic, 565, 1372, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld73", siebendreipic, 398, 1181, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld74", siebenvierpic, 591, 1261, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld75", siebenfuenfpic, 432, 1021, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld76", siebensechspic, 611, 1139, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld77", siebensiebenpic, 773, 1222, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld78", siebenachtpic, 657, 1045, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld79", siebenneunpic, 487, 890, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld80", achtnullpic, 551, 808, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld81", achteinspic, 605, 742, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld82", achtzweipic, 181, 1035, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld83", achtdreipic, 244, 982, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld84", achtvierpic, 134, 906, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld85", achtfuenfpic, 85, 837, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld86", achtsechspic, 168, 796, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld87", achtsiebenpic, 215, 752, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld88", achtachtpic, 286, 695, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld89", achtneunpic, 376, 636, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld90", neunnullpic, 102, 654, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld91", neuneinspic, 122, 528, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld92", neunzweipic, 291, 520, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld93", neundreipic, 91, 406, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld94", neunvierpic, 185, 406, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld95", neunfuenfpic, 316, 371, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld96", neunsechspic, 416, 400, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld97", neunsiebenpic, 512, 358, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld98", neunachtpic, 424, 269, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld99", neunneunpic, 532, 230, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld100", einsnullnullpic, 137, 248, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld101", einsnulleinspic, 137, 87, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld102", einsnullzweipic, 292, 125, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld103", einsnulldreipic, 427, 115, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld104", einsnullvierpic, 527, 87, 0.025, 0.040, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld105", einsnullfuenfpic, 653, 158, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Feld106", einsnullsechspic, 656, 54, 0.025, 0.040, false, false, 0);
	
	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Feld107", einsnullsiebenpic, 807, 137, 0.025, 0.040, false, false, 0);
	

    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
