﻿--
-- airsprayer.lua
-- Specialication for moving CuttingArea in relation to airplane-aspects
-- @author  Sven777b
-- 
-- Diese Spezi bewegt die CuttingArea in Abhngigkeit von Flughhe und Geschwindigkeit
--


airsprayer = {};

function airsprayer.prerequisitesPresent(specializations)
		return SpecializationUtil.hasSpecialization(airplane, specializations);
end;

function airsprayer:load(xmlFile)
	self.checkSpeedLimit = false;
	self.cuttingAreaPositions = {};
	for k,c in pairs (self.cuttingAreas) do
		local xs,ys,zs = getTranslation(c.start);
		local xw,yw,zw = getTranslation(c.width);
		local xh,yh,zh = getTranslation(c.height);
		local cap = {};
		cap.start = {xs,ys,zs};
		cap.width = {xw,yw,zw};
		cap.height = {xh,yh,zh};
		table.insert(self.cuttingAreaPositions, cap);
	end;
end;

function airsprayer:delete()
end;

function airsprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function airsprayer:keyEvent(unicode, sym, modifier, isDown)
end;

function airsprayer:update(dt)
	--Sprayer versatz
	if self:getIsActive() and self.isTurnedOn then
		local addw = self.ALTagl*20;
		local addh = self.ALTagl/5;
		local addz = (self.ALTagl/2) + (self.airspeed/50);
		for c=1, table.getn(self.cuttingAreas) do
			local cp = self.cuttingAreaPositions[c];
			local ca = self.cuttingAreas[c];
			setTranslation(ca.start ,  cp.start[1]+ (cp.start[1] *addw/100) , cp.start[2]  , cp.start[3]- addz);
			setTranslation(ca.width ,  cp.width[1]+ (cp.width[1] *addw/100) , cp.width[2]  , cp.width[3]- addz);
			if self.ALTagl > 30 then
				setTranslation(ca.height , cp.start[1]+(cp.start[1]*addw/100) , cp.start[2] , cp.start[3] - addz);
			else
				setTranslation(ca.height , cp.height[1]+(cp.height[1]*addw/100) , cp.height[2] , cp.height[3]-addz-addh);
			end;
		end;
	end;
end;

function airsprayer:draw()
	if self.isTurnedOn and self.ALTagl > 30 then
		g_currentMission:addWarning("Sie fliegen zu hoch zum spruehen (max. 30m agl)", 0.07+0.022, 0.019+0.029);
	end;
end;

	
	
