--
-- Beleuchtung v1.0
-- Specialization for additional lights
-- Spezialisierung fr Zusatzbeleuchtung
-- @author  Sven777b
-- 
-- Modifikationen erst nach Rcksprache!
--

LICHTADDON = {};

function LICHTADDON.prerequisitesPresent(specializations)
		print("specialization beleuchtung v1.0 by Sven777b");
    return true;
end;

function LICHTADDON:load(xmlFile)
--Rundumleuchten
		local i = 0;
		self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
    self.rundumleuchtenprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rundumleuchten#prefix"),"");
		while true do
			local rul = {};
			local objname = string.format("vehicle.rundumleuchten.licht(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then break; end;
      rul = {};
      rul.rotNode = Utils.indexToObject(self.components, rotnode);
      rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (rul.source == nil) then
	      	rul.emit = false;
	      else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul);
      end;
      i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);
--Arbeitslichter
    local i = 0;
    self.zusatzlampen = {};
    self.zusatzlampenprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.zusatzlichter#prefix"),"");
    while true do
    	local objname = string.format("vehicle.zusatzlichter.licht(%d)",i);
    	local index = getXMLString(xmlFile, objname .. "#index");
    	if index == nil then break;	end;
    	local licht = {};
    	licht.index = Utils.indexToObject(self.components,index);
    	if licht.index == nil then
    		print("Error: Index ("..index..") zum Zusatzlicht "..i.." nicht gefunden");
    	else
    		licht.istAn = false;
    		setVisibility(licht.index, false);
    		licht.id = Utils.getNoNil(getXMLString(xmlFile, objname.."#id"),i);
    		licht.info = Utils.getNoNil(getXMLBool(xmlFile, objname.."#hilfetext"),true);
    		table.insert(self.zusatzlampen, licht);
    	end;
    	i = i + 1;
    end;
    self.zusatzlampenAnz = table.getn(self.zusatzlampen);
--Positionslichter
		local i=0;
		self.poslichter = {};
		self.posstrobes = {};
		self.posdays = {};
		self.poslichterprefix = Utils.getNoNil(getXMLString(xmlFile, "vehicle.positionslichter#prefix"),"");
		self.poslichterAn = false;
		self.posdaysAn = false;
		while true do
			local objname = string.format("vehicle.positionslichter.licht(%d)",i);
			local index = getXMLString(xmlFile, objname.."#index");
			if index == nil then break; end;
			local licht = {};
			licht.index = Utils.indexToObject(self.components,index);
    	if licht.index == nil then
    		print("Error: Index ("..index..") zum Positionslicht "..i.." nicht gefunden");
    	else
    		setVisibility(licht.index, false);
    		licht.typ = Utils.getNoNil(getXMLString(xmlFile,objname.."#typ"),"perma");
    		if licht.typ == "strobe" then
    			licht.sequences = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, objname.."#sequenz"),"1"))};
    			table.insert(self.posstrobes,licht);
    		elseif licht.typ == "daylight" then
    			table.insert(self.posdays,licht);
    		else
    			table.insert(self.poslichter,licht);
    		end;
    	end;
    	i=i+1;
    end;
    self.poslichterAnz = table.getn(self.poslichter);
    self.posstrobesAnz = table.getn(self.posstrobes);
    self.posdaysAnz = table.getn(self.posdays);
--Verstellungen
		local i=0;
		self.verstell = {};
		while true do
			local objname = string.format("vehicle.verstellungen.licht(%d)",i);
			local index = getXMLString(xmlFile, objname.."#index");
			if index == nil then break; end;
			local obj = {};
			obj.index = Utils.indexToObject(self.components,index);
			if obj.index == nil then
				print("Error: Index ("..index..") zum Licht "..i.." nicht gefunden");
			else
				obj.key1 = Input[getXMLString(xmlFile, objname.."#taste1")];
				if obj.key1 == nil then
					print("Error: taste1 fuer Verstellung "..i.." nicht gefunden"); break;
				end;
				obj.key2 = Input[getXMLString(xmlFile, objname.."#taste2")];
				if obj.key2 == nil then
					print("Error: taste2 fuer Verstellung "..i.." nicht gefunden"); break;
				end;
				obj.min = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#min"),0);
				obj.max = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#max"),0);
				obj.step = Utils.getNoNil(getXMLFloat(xmlFile, objname.."#step"),0.1);
				obj.axis = Utils.getNoNil(getXMLInt(xmlFile, objname.."#axis"),1);
				table.insert(self.verstell,obj);
			end;
			i=i+1;
		end;
		self.verstellAnz = table.getn(self.verstell);
end;

function LICHTADDON:delete()
	if self.rundumleuchtenAnz > 0 then
		self.rundumleuchtenAn = false;
		for i=1,self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, false);
		end;
	end;
	if self.zusatzlampenAnz > 0 then
		for i=1,self.zusatzlampenAnz do
			self.zusatzlampen[i].istAn = false;
			setVisibility(self.zusatzlampen[i].index , false);
		end;
	end;
end;

function LICHTADDON:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LICHTADDON:keyEvent(unicode, sym, modifier, isDown)
end;

function LICHTADDON:update(dt)
	if self:getIsActive() then
		if self.rundumleuchtenAnz > 0 then
	    if InputBinding.hasEvent(InputBinding[self.rundumleuchtenprefix..'RUNDUMLEUCHTE']) then
	    	self.rundumleuchtenAn = not self.rundumleuchtenAn;
	      for i=1, self.rundumleuchtenAnz do
	        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	      end;
	    end;
	    if self.rundumleuchtenAn then
	      for i=1, self.rundumleuchtenAnz do
	        rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
	      end;
	    end;
	  end;
	  if self.zusatzlampenAnz > 0 then
	  	for i=1, self.zusatzlampenAnz do
	  		local licht = self.zusatzlampen[i];
	  		if InputBinding.hasEvent(InputBinding[self.zusatzlampenprefix..'ZUSATZLICHT'..licht.id]) then
	  			licht.istAn = not licht.istAn;
	  			setVisibility(licht.index, licht.istAn);
	  		end;
	  	end;
	  end;
	  if not self.poslichterAn then
	  	self.poslichterAn = true;
	  	if self.poslichterAnz > 0 then
				for i=1,self.poslichterAnz do
					setVisibility(self.poslichter[i].index,true);
				end;
			end;
		end;
		if self.lightsActive == self.posdaysAn then
			self.posdaysAn = not self.lightsActive;
			if self.posdaysAnz > 0 then
				for i=1,self.posdaysAnz do
					setVisibility(self.posdays[i].index, self.posdaysAn);
				end;
			end;
		end;

		if self.posstrobesAnz > 0 then
			for i=1,self.posstrobesAnz do
				local licht = self.posstrobes[i];
				if licht.nextseq == nil then licht.nextseq = 1; end;
				if licht.seqtimer == nil then licht.seqtimer = 0; end;
				if licht.seqtimer > licht.sequences[licht.nextseq] then
					local status = getVisibility(licht.index);
					setVisibility(licht.index , not status);
					licht.seqtimer = 0;
					licht.nextseq = licht.nextseq+1;
					if licht.nextseq > table.getn(licht.sequences) then
						licht.nextseq = 1;
					end;
				else
					licht.seqtimer = licht.seqtimer + (dt/1000);
				end;
			end;
		end;
		
		if self.verstellAnz > 0 then
			for i=1,self.verstellAnz do 
				local v = self.verstell[i];
				local m = 0;
				if Input.isKeyPressed(v.key1) then
					m = math.rad(dt/1000*v.step);
				elseif Input.isKeyPressed(v.key2) then
					m = math.rad(-dt/1000*v.step);
				end;
				if m ~= 0 then
					local rot = {getRotation(v.index)};
					if (rot[v.axis]+m < math.rad(v.max)) and (rot[v.axis]+m > math.rad(v.min)) then
						local nrot = {0,0,0};
						nrot[v.axis] = m;
						rotate(v.index,unpack(nrot));
					end;
				end;
			end;
		end;
				
		
  end;
end;

function LICHTADDON:draw()
   g_currentMission:addExtraPrintText(); 
    if self.zusatzlampenAnz > 0 and self:getIsActive() then
    		for i=1, self.zusatzlampenAnz do
    			if self.zusatzlampen[i].info then
    				g_currentMission:addHelpButtonText(g_i18n:getText(self.zusatzlampenprefix.."zusatzlicht"..self.zusatzlampen[i].id), InputBinding[self.zusatzlampenprefix..'ZUSATZLICHT'..self.zusatzlampen[i].id]);
    			end;
    		end;
    end;

end;

function LICHTADDON:onLeave()
	if self.rundumleuchtenAnz > 0 then
		self.rundumleuchtenAn = false;
		for i=1,self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, false);
		end;
	end;
	if self.zusatzlampenAnz > 0 then
		for i=1,self.zusatzlampenAnz do
			self.zusatzlampen[i].istAn = false;
			setVisibility(self.zusatzlampen[i].index , false);
		end;
	end;
	if self.poslichterAn and self.poslichterAnz > 0 then
		self.poslichterAn = false;
		for i=1,self.poslichterAnz do
			setVisibility(self.poslichter[i].index,false);
		end;
	end;
	if self.posstrobesAnz > 0 then
		for i=1,self.posstrobesAnz do
			self.posstrobes[i].seqtimer = 0;
			self.posstrobes[i].nextseq = 1;
			setVisibility(self.posstrobes[i].index, false);
		end;
	end;
	if self.posdaysAn and self.posdaysAnz > 0 then
		self.posdaysAn = false;
		for i=1,self.posdaysAnz do
			setVisibility(self.posdays[i].index,false);
		end;
	end;
end;