
PickupWheelEvent = {};
PickupWheelEvent_mt = Class(PickupWheelEvent, Event);

InitEventClass(PickupWheelEvent, "PickupWheelEvent");

function PickupWheelEvent:emptyNew()
    local self = Event:new(PickupWheelEvent_mt);
    self.className="PickupWheelEvent";
    return self;
end;

function PickupWheelEvent:new(vehicle, wheel)
    local self = PickupWheelEvent:emptyNew()
    self.vehicle = vehicle;
	self.wheel = wheel;
    return self;
end;

function PickupWheelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.wheel = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PickupWheelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.wheel);	
end;

function PickupWheelEvent:run(connection)
	self.vehicle:setWheel(self.wheel, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PickupWheelEvent:new(self.vehicle, self.wheel), nil, connection, self.object);
	end;
end;

function PickupWheelEvent.sendEvent(vehicle, wheel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PickupWheelEvent:new(vehicle, wheel), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PickupWheelEvent:new(vehicle, wheel));
		end;
	end;
end;
