setTableWorkState = {};
setTableWorkState_mt = Class(setTableWorkState, Event);

InitEventClass(setTableWorkState, "setTableWorkState");

function setTableWorkState:emptyNew()
    local self = Event:new(setTableWorkState_mt);
    self.className="setTableWorkState";
    return self;
end;

function setTableWorkState:new(object, isCoupling)
    local self = setTableWorkState:emptyNew()
    self.object = object;
	self.isCoupling = isCoupling;
    return self;
end;

function setTableWorkState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCoupling = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function setTableWorkState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCoupling);
end;

function setTableWorkState:run(connection)   
	self.object:setTableWorkState(self.isCoupling, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setTableWorkState:new(self.object, self.isCoupling), nil, connection, self.object);
    end;
end;

function setTableWorkState.sendEvent(vehicle, isCoupling, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setTableWorkState:new(vehicle, isCoupling), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setTableWorkState:new(vehicle, isCoupling));
		end;
	end;
end;

