ArmWorkStateEvent = {};
ArmWorkStateEvent_mt = Class(ArmWorkStateEvent, Event);

InitEventClass(ArmWorkStateEvent, "ArmWorkStateEvent");

function ArmWorkStateEvent:emptyNew()
    local self = Event:new(ArmWorkStateEvent_mt);
    self.className="ArmWorkStateEvent";
    return self;
end;

function ArmWorkStateEvent:new(vehicle, isCoupled)
    local self = ArmWorkStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.isCoupled = isCoupled;
    return self;
end;

function ArmWorkStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCoupled = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ArmWorkStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isCoupled);
end;

function ArmWorkStateEvent:run(connection)   
	self.vehicle:setArmWorkState(self.isCoupled, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ArmWorkStateEvent:new(self.vehicle, self.isCoupled), nil, connection, self.vehicle);
    end;
end;

function ArmWorkStateEvent.sendEvent(vehicle, isCoupled, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ArmWorkStateEvent:new(vehicle, isCoupled), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ArmWorkStateEvent:new(vehicle, isCoupled));
		end;
	end;
end;