SetUnloadingEvent = {};
SetUnloadingEvent_mt = Class(SetUnloadingEvent, Event);

InitEventClass(SetUnloadingEvent, "SetUnloadingEvent");

function SetUnloadingEvent:emptyNew()
	local self = Event:new(SetUnloadingEvent_mt);
	self.className="SetUnloadingEvent";
	return self;
end;

function SetUnloadingEvent:new(vehicle, isUnloading)
	local self = SetUnloadingEvent:emptyNew()
	self.vehicle = vehicle;
	self.isUnloading = isUnloading;
	return self;
end;

function SetUnloadingEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isUnloading = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetUnloadingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isUnloading);
end;

function SetUnloadingEvent:run(connection)   
	self.vehicle:setUnloading(self.isUnloading, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetUnloadingEvent:new(self.vehicle, self.isUnloading), nil, connection, self.vehicle);
	end;
end;

function SetUnloadingEvent.sendEvent(vehicle, isUnloading, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetUnloadingEvent:new(vehicle, isUnloading), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetUnloadingEvent:new(vehicle, isUnloading));
		end;
	end;
end;