SetArmMiddleUpEvent = {};
SetArmMiddleUpEvent_mt = Class(SetArmMiddleUpEvent, Event);

InitEventClass(SetArmMiddleUpEvent, "SetArmMiddleUpEvent");

function SetArmMiddleUpEvent:emptyNew()
	local self = Event:new(SetArmMiddleUpEvent_mt);
	self.className="SetArmMiddleUpEvent";
	return self;
end;

function SetArmMiddleUpEvent:new(vehicle, isArmMiddleUp)
	local self = SetArmMiddleUpEvent:emptyNew()
	self.vehicle = vehicle;
	self.isArmMiddleUp = isArmMiddleUp;
	return self;
end;

function SetArmMiddleUpEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isArmMiddleUp = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetArmMiddleUpEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmMiddleUp);
end;

function SetArmMiddleUpEvent:run(connection)   
	self.vehicle:setArmMiddleUp(self.isArmMiddleUp, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetArmMiddleUpEvent:new(self.vehicle, self.isArmMiddleUp), nil, connection, self.vehicle);
	end;
end;

function SetArmMiddleUpEvent.sendEvent(vehicle, isArmMiddleUp, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmMiddleUpEvent:new(vehicle, isArmMiddleUp), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmMiddleUpEvent:new(vehicle, isArmMiddleUp));
		end;
	end;
end;