SetTurnToLoadEvent = {};
SetTurnToLoadEvent_mt = Class(SetTurnToLoadEvent, Event);

InitEventClass(SetTurnToLoadEvent, "SetTurnToLoadEvent");

function SetTurnToLoadEvent:emptyNew()
	local self = Event:new(SetTurnToLoadEvent_mt);
	self.className="SetTurnToLoadEvent";
	return self;
end;

function SetTurnToLoadEvent:new(vehicle, isLoading)
	local self = SetTurnToLoadEvent:emptyNew()
	self.vehicle = vehicle;
	self.isLoading = isLoading;
	return self;
end;

function SetTurnToLoadEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isLoading = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetTurnToLoadEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoading);
end;

function SetTurnToLoadEvent:run(connection)   
	self.vehicle:setTurnToLoad(self.isLoading, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTurnToLoadEvent:new(self.vehicle, self.isLoading), nil, connection, self.vehicle);
	end;
end;

function SetTurnToLoadEvent.sendEvent(vehicle, isLoading, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTurnToLoadEvent:new(vehicle, isLoading), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTurnToLoadEvent:new(vehicle, isLoading));
		end;
	end;
end;