SetBalesEvent = {};
SetBalesEvent_mt = Class(SetBalesEvent, Event);

InitEventClass(SetBalesEvent, "SetBalesEvent");

function SetBalesEvent:emptyNew()
	local self = Event:new(SetBalesEvent_mt);
	self.className="SetBalesEvent";
	return self;
end;

function SetBalesEvent:new(object, active)
	local self = SetBalesEvent:emptyNew()
	self.active = active;
	self.object = object;
	return self;
end;

function SetBalesEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.active = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
 end;

function SetBalesEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);
end;

function SetBalesEvent:run(connection)
	self.object:setBalesVisibility(self.active, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBalesEvent:new(self.object, self.active), nil, connection, self.object);
	end;
end;