SetAnimationEvent = {};
SetAnimationEvent_mt = Class(SetAnimationEvent, Event);

InitEventClass(SetAnimationEvent, "SetAnimationEvent");

function SetAnimationEvent:emptyNew()
	local self = Event:new(SetAnimationEvent_mt);
	self.className = "SetAnimationEvent";
	return self;
end;

function SetAnimationEvent:new(object, animationIndex, inputTime)
	local self = SetAnimationEvent:emptyNew()
	self.object = object;
	self.animationIndex = animationIndex;
	self.inputTime = inputTime;
	return self;
end;

function SetAnimationEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.animationIndex = streamReadInt32(streamId);
	self.inputTime = streamReadInt32(streamId);
	self:run(connection);
end;

function SetAnimationEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.animationIndex);
	streamWriteInt32(streamId, self.inputTime);
end;

function SetAnimationEvent:run(connection)
	self.object:setAnimationTime(self.animationIndex, self.inputTime, true)
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetAnimationEvent:new(self.object, self.animationIndex, self.inputTime), nil, connection, self.object);
	end;
end;

function SetAnimationEvent.sendEvent(vehicle, animationIndex, inputTime, noEventSend)
	local animationPart = vehicle.animationParts[animationIndex];
	if animationPart ~= nil then
		if inputTime ~= vehicle.animationParts[animationIndex].inputTime then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SetAnimationEvent:new(vehicle, animationIndex, inputTime), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(SetAnimationEvent:new(vehicle, animationIndex, inputTime));
				end;
			end;
		end;
	end;
end;
