SetActiveBaleEvent = {};
SetActiveBaleEvent_mt = Class(SetActiveBaleEvent, Event);

InitEventClass(SetActiveBaleEvent, "SetActiveBaleEvent");

function SetActiveBaleEvent:emptyNew()
	local self = Event:new(SetActiveBaleEvent_mt);
	self.className="SetActiveBaleEvent";
	return self;
end;

function SetActiveBaleEvent:new(vehicle, activeBale)
	local self = SetActiveBaleEvent:emptyNew()
	self.vehicle = vehicle;
	self.activeBale = activeBale;
	return self;
end;

function SetActiveBaleEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.activeBale = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetActiveBaleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.activeBale);
end;

function SetActiveBaleEvent:run(connection)   
	self.vehicle:setResetActiveBale(self.activeBale, true);
	if not connection:getIsServer() then
	g_server:broadcastEvent(SetActiveBaleEvent:new(self.vehicle, self.activeBale), nil, connection, self.vehicle);
	end;
end;

function SetActiveBaleEvent.sendEvent(vehicle, activeBale, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetActiveBaleEvent:new(vehicle, activeBale), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetActiveBaleEvent:new(vehicle, activeBale));
		end;
	end;
end;