setArmWorkState = {};
setArmWorkState_mt = Class(setArmWorkState, Event);

InitEventClass(setArmWorkState, "setArmWorkState");

function setArmWorkState:emptyNew()
    local self = Event:new(setArmWorkState_mt);
    self.className="setArmWorkState";
    return self;
end;

function setArmWorkState:new(object, isCoupling)
    local self = setArmWorkState:emptyNew()
    self.object = object;
	self.isCoupling = isCoupling;
    return self;
end;

function setArmWorkState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCoupling = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function setArmWorkState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCoupling);
end;

function setArmWorkState:run(connection)   
	self.object:setArmWorkState(self.isCoupling, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setArmWorkState:new(self.object, self.isCoupling), nil, connection, self.object);
    end;
end;

function setArmWorkState.sendEvent(vehicle, isCoupling, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setArmWorkState:new(vehicle, isCoupling), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setArmWorkState:new(vehicle, isCoupling));
		end;
	end;
end;

