-- Power Command change shuttle direction event-class
ChangeShuttleDirectionEvent = {};
ChangeShuttleDirectionEvent_mt = Class(ChangeShuttleDirectionEvent, Event);

InitEventClass(ChangeShuttleDirectionEvent, "ChangeShuttleDirectionEvent");

function ChangeShuttleDirectionEvent:emptyNew()
    local self = Event:new(ChangeShuttleDirectionEvent_mt);
    self.className="ChangeShuttleDirectionEvent";
    return self;
end;

function ChangeShuttleDirectionEvent:new(vehicle, currentShuttleDirection)
    local self = ChangeShuttleDirectionEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentShuttleDirection = currentShuttleDirection;
    return self;
end;

function ChangeShuttleDirectionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.currentShuttleDirection = streamReadString(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeShuttleDirectionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteString(streamId, self.currentShuttleDirection);
end;

function ChangeShuttleDirectionEvent:run(connection)
	self.vehicle:changeShuttleDirection(self.currentShuttleDirection, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeShuttleDirectionEvent:new(self.vehicle, self.currentShuttleDirection), nil, connection, self.vehicle);
    end;
end;

function ChangeShuttleDirectionEvent.sendEvent(vehicle, currentShuttleDirection, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeShuttleDirectionEvent:new(vehicle, currentShuttleDirection), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeShuttleDirectionEvent:new(vehicle, currentShuttleDirection));
		end;
	end;
end;
