-- Power Command change reverse gear event-class
ChangeRevGearEvent = {};
ChangeRevGearEvent_mt = Class(ChangeRevGearEvent, Event);

InitEventClass(ChangeRevGearEvent, "ChangeRevGearEvent");

function ChangeRevGearEvent:emptyNew()
    local self = Event:new(ChangeRevGearEvent_mt);
    self.className="ChangeRevGearEvent";
    return self;
end;

function ChangeRevGearEvent:new(vehicle, newRevGear)
    local self = ChangeRevGearEvent:emptyNew()
    self.vehicle = vehicle;
	self.newRevGear = newRevGear;
    return self;
end;

function ChangeRevGearEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.newRevGear = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeRevGearEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.newRevGear);
end;

function ChangeRevGearEvent:run(connection)
	self.vehicle:changeRevGear(self.newRevGear, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeRevGearEvent:new(self.vehicle, self.newRevGear), nil, connection, self.vehicle);
    end;
end;

function ChangeRevGearEvent.sendEvent(vehicle, newRevGear, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeRevGearEvent:new(vehicle, newRevGear), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeRevGearEvent:new(vehicle, newRevGear));
		end;
	end;
end;
