-- Power Command change forward gear event-class
ChangeFwdGearEvent = {};
ChangeFwdGearEvent_mt = Class(ChangeFwdGearEvent, Event);

InitEventClass(ChangeFwdGearEvent, "ChangeFwdGearEvent");

function ChangeFwdGearEvent:emptyNew()
    local self = Event:new(ChangeFwdGearEvent_mt);
    self.className="ChangeFwdGearEvent";
    return self;
end;

function ChangeFwdGearEvent:new(vehicle, newFwdGear)
    local self = ChangeFwdGearEvent:emptyNew()
    self.vehicle = vehicle;
	self.newFwdGear = newFwdGear;
    return self;
end;

function ChangeFwdGearEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.newFwdGear = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeFwdGearEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.newFwdGear);
end;

function ChangeFwdGearEvent:run(connection)
	self.vehicle:changeFwdGear(self.newFwdGear, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeFwdGearEvent:new(self.vehicle, self.newFwdGear), nil, connection, self.vehicle);
    end;
end;

function ChangeFwdGearEvent.sendEvent(vehicle, newFwdGear, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeFwdGearEvent:new(vehicle, newFwdGear), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeFwdGearEvent:new(vehicle, newFwdGear));
		end;
	end;
end;
