--
-- Einblendung .lua 
-- Specialization Einblendung
--
-- www.LS-Landtechnik.de
-- @author  LS-Landtechnik.de & DarkMichl
-- @date:		27/12/10
-- @version:	v2.0
-- @copyright:	LS-Landtechnik.de  & DarkMichl


EinblendungTVL2 = {};

function EinblendungTVL2.prerequisitesPresent(specializations)
    return true;
end;
function EinblendungTVL2:load(xmlFile)

	self.setblends1Visibility = SpecializationUtil.callSpecializationsFunction("setblends1Visibility");
	self.setblends2Visibility = SpecializationUtil.callSpecializationsFunction("setblends2Visibility");
	
    self.blends1 = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends1.blend1(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
             break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends1, {node=node});
        end;
        i = i + 1;
        end;
    self.blends1Active = false;
	
    self.blends2 = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends2.blend2(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
            break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends2, {node=node});
        end;
        i = i + 1;
    end;
	self.blends2Active = false;
end;
function EinblendungTVL2:delete()
end;
function EinblendungTVL2:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1Visibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends2Visibility(visibility, true);
end;

function EinblendungTVL2:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1Active);
	streamWriteBool(streamId, self.blends2Active);
end;
function EinblendungTVL2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function EinblendungTVL2:keyEvent(unicode, sym, modifier, isDown)
end;
function EinblendungTVL2:update(dt)

    if self:getIsActiveForInput() and self.isClient then
        if InputBinding.hasEvent(InputBinding.EinblendungTVL2Eins) then
              self:setblends1Visibility(not self.blends1Active);
        end;
        if InputBinding.hasEvent(InputBinding.EinblendungTVL2Zwei) then
              self:setblends2Visibility(not self.blends2Active);
        end;
	end;
end;
function EinblendungTVL2:onLeave()
end;
function EinblendungTVL2:draw()
end;
function EinblendungTVL2:setblends1Visibility(visibility, noEventSend)
    if visibility ~= self.blends1Active then
  
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends1Event:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends1Event:new(self, visibility));
            end;
        end;
  
        self.blends1Active = visibility;
  
        for _, blend1 in pairs(self.blends1) do
            setVisibility(blend1.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend1Visibility ~= nil then
                v.setblend1Visibility(self, visibility);
            end;
        end;
    end;
end;
function EinblendungTVL2:setblends2Visibility(visibility, noEventSend)
    if visibility ~= self.blends2Active then
  
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends2Event:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends2Event:new(self, visibility));
            end;
        end;
  
        self.blends2Active = visibility;
  
        for _, blend2 in pairs(self.blends2) do
            setVisibility(blend2.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend2Visibility ~= nil then
                v.setblend2Visibility(self, visibility);
            end;
        end;
    end;
end;

