--
-- MasseyFerguson8690
--
-- @autor Wallu
--
--
--  XML FILE:  	<seatNode index=" " /> 
--
MasseyFerguson8690 = {};

function MasseyFerguson8690.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MasseyFerguson8690:load(xmlFile)
	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;

	self.seatNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seatNode#index"));

	if self.seatNode ~=nil then
		local x,y,z = getTranslation(self.seatNode);
		self.startSeatXTranslation = x;
		self.startSeatYTranslation = y;
		self.startSeatZTranslation = z;
	end;

	if self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[3].repr);
		local x2,y2,z2 = getTranslation(self.wheels[4].repr);

		self.averageYTranslation = (y + y2)/2;
	end;

	self.maxTranslationPrCycle = 0.00008;
	self.seatTranslation = self.averageYTranslation;
end;
function MasseyFerguson8690:delete()
end;

function MasseyFerguson8690:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MasseyFerguson8690:keyEvent(unicode, sym, modifier, isDown)
end;

function MasseyFerguson8690:update(dt)
if self.inrange or self.isEntered then

		local maxrpmneedle = 900;
			if self.rotationPart1 ~= nil then
				local x, y, z = getRotation(self.rotationPart1.node);
				y = ((self.rotationPart1.maxRot[2] - self.rotationPart1.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm/2.2) + self.rotationPart1.minRot[2];
				setRotation(self.rotationPart1.node, x, y ,z);
			end;

	if self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[3].repr);
		local x2,y2,z2 = getTranslation(self.wheels[4].repr);

		self.averageYTranslation = (y + y2)/2;
	end;

	if self.seatTranslation > self.averageYTranslation then
		self.seatTranslation = self.seatTranslation - self.maxTranslationPrCycle * dt;
		if self.seatTranslation < self.averageYTranslation then
			self.seatTranslation = self.averageYTranslation;
		end;
	elseif self.seatTranslation < self.averageYTranslation then
		self.seatTranslation = self.seatTranslation + self.maxTranslationPrCycle * dt;
		if self.seatTranslation > self.averageYTranslation then
			self.seatTranslation = self.averageYTranslation;
		end;
	end;

	if self.seatNode ~= nil then
		setTranslation(self.seatNode, self.startSeatXTranslation, self.seatTranslation, self.startSeatZTranslation);
	end;
end;
function MasseyFerguson8690:updateTick(dt)
end;

function MasseyFerguson8690:draw()  
end;

function MasseyFerguson8690:onLeave()
end;

end;