-- krokodyl
-- 
-- Shovel/Grab supporting DLC2-BGA, HS-BGA, manureHeap, AlternativeTipping
--
-- Author: Sven (sven777b) Brutigam
-- Thx to Face for the permission to connect this Shovel to Alternative Tipping
-- Copyright (C) Halycon Media & Sven Brutigam


krokodyl = {};

function krokodyl.prerequisitesPresent(specializations)
	return true;
end;

function krokodyl:load(xmlFile)
    self.getIsManureEmptying = krokodyl.getIsManureEmptying;
    self.getAllowFillShovel = krokodyl.getAllowFillShovel;
    self.findUnloadTargetRaycastCallback = krokodyl.findUnloadTargetRaycastCallback;
    self.setManureIsFilled = SpecializationUtil.callSpecializationsFunction("setManureIsFilled");
    self.getIsShovelEmptying = SpecializationUtil.callSpecializationsFunction("getIsShovelEmptying");
    self.onEndTip = SpecializationUtil.callSpecializationsFunction("onEndTip");
    self.onStartTip = SpecializationUtil.callSpecializationsFunction("onStartTip");
    self.allowAltTipping = SpecializationUtil.callSpecializationsFunction("allowAltTipping");
    self.getCurrentFruitType = Trailer.getCurrentFruitType;

	self.manureCapacity = 100;
	self.lastFillLevel = 0;
	self.manureIsFilled = false;
	self.isShovel = true;
	self.allowFillFromShovelTrigger = true;
	self.shovelTipReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipReferenceNode#index"));
	self.triggerPlacement = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.triggerPlacement#index"));
	self.targetFound = 0;
	self.allowTipDischarge = true;

    self.emptyParticleSystems = {};
    Utils.loadParticleSystem(xmlFile, self.emptyParticleSystems, "vehicle.emptyParticleSystem", self.components, false, nil, self.baseDirectory);
    self.shovelDirtyFlag = self:getNextDirtyFlag();
	self.psActive = false;
	
	self.tipState = Trailer.TIPSTATE_CLOSED;
	self.isTriggerPlaceDefined = false;
	self.altTippingAllowed = false;
	self.tooMuchAltTipping = false;
	self.warningTimer = 0;
	self.maxHeaps = 10;
	if g_currentMission.alternativeTipTrigger ~= nil then
		g_currentMission.alternativeTipTrigger.isCallbackValid = Utils.prependedFunction(g_currentMission.alternativeTipTrigger.isCallbackValid, krokodyl.isCallbackValid);
	end;
	
end;

function krokodyl:delete()
	Utils.deleteParticleSystem(self.emptyParticleSystems);
end;

function krokodyl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function krokodyl:keyEvent(unicode, sym, modifier, isDown)
end;

function krokodyl:update(dt)
	if g_currentMission.alternativeTipTrigger ~= nil then
		if InputBinding.hasEvent(InputBinding.ALTERNATIVETIPPING_START_TIPPING) and Input.isKeyPressed(Input.KEY_lctrl) then
			self:allowAltTipping(not self.altTippingAllowed);
		end;
	end;
end;

function krokodyl:updateTick(dt)
	if self:getIsActive() then
		if self.tooMuchAltTipping then
			if self.warningTimer < 3000 then
				self.warningTimer = self.warningTimer + dt;
			else
				self.warningTimer = 0;
				self.tooMuchAltTipping = false;
			end;
		end;
		self.transfer = 0;
		self.manureIsFilled = self.fillLevel >= self.capacity;
		if self.isServer then
			if self.fillLevel > 0 and self.movingTools[1].curRot[1] > math.rad(30) then
				local dx,dy,dz = localDirectionToWorld(self.shovelTipReferenceNode, 0,0,1);
				if dy < math.rad(-20) then	
					self.transfer = math.min(self.fillLevel, (math.abs(math.deg(dy))-20)/10*dt);
					if krokodyl:checkForTipTriggers(self) then
					elseif krokodyl:checkForTrailers(self) then
					elseif krokodyl:checkForMMSTrigger(self) then
					elseif self.altTippingAllowed then
						krokodyl:checkForAlternativeTipping(self);
					else self.transfer = 0; end;
					if self.transfer > 0 then
						self:setFillLevel(self.fillLevel - self.transfer , self.currentFillType);
					end;
				end;
			end;
		end;
		if self.lastFillLevel ~= self.fillLevel then
			self.lastFillLevel = self.fillLevel;
			if not self.psActive then
				Utils.resetNumOfEmittedParticles(self.emptyParticleSystems)
				Utils.setEmittingState(self.emptyParticleSystems, true);
				self.psActive = true;
			end;
		else
			if self.psActive then
				Utils.setEmittingState(self.emptyParticleSystems, false);
				self.psActive = false;
			end;
		end;
	end;
end;

function krokodyl:draw(dt)
	if g_currentMission.alternativeTipTrigger ~= nil then
		if self.tooMuchAltTipping then
			g_currentMission:addWarning(g_i18n:getText("TOO_MUCH_ALT_TIPPING"), 0.018, 0.033);
		else
			if self.altTippingAllowed then
				g_currentMission:addHelpButtonText(g_i18n:getText("DISALLOW_ALT_TIPPING"), InputBinding.ALTERNATIVETIPPING_START_TIPPING);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("ALLOW_ALT_TIPPING"), InputBinding.ALTERNATIVETIPPING_START_TIPPING);
			end;
		end;
	end;
end;

function krokodyl:onAttach()
end;

function krokodyl:onDetach()
end;

function krokodyl:getIsManureEmptying()
	local isClosed = self.movingTools[1].curRot[1] < math.rad(30);
	local dx,dy,dz = localDirectionToWorld(self.shovelTipReferenceNode, 0,0,1);
	return isClosed or dy < math.rad(-10);
end;

function krokodyl:getIsShovelEmptying()
	local isClosed = self.movingTools[1].curRot[1] < math.rad(30);
	local dx,dy,dz = localDirectionToWorld(self.shovelTipReferenceNode, 0,0,1);
	return isClosed or dy < math.rad(-10);
end;

function krokodyl:getAllowFillShovel(filltype)
	local fillTypeAllowed = self:allowFillType(filltype);
	local isOpen = self.movingTools[1].curRot[1] > math.rad(30);
	local isNotFull = self.fillLevel < self.capacity;
	local dx,dy,dz = localDirectionToWorld(self.shovelTipReferenceNode, 0,0,1);
	return isOpen and isNotFull and dy > math.rad(-10) and fillTypeAllowed;
end;

function krokodyl:setManureIsFilled(isFilled)
    if self.manureIsFilled ~= isFilled then
        if self.isServer then
            self:raiseDirtyFlags(self.shovelDirtyFlag);
            if isFilled then
				if self.fillLevel < self.capacity then
            			self:setFillLevel(self.fillLevel + self.manureCapacity, Fillable.FILLTYPE_MANURE);
            		end;
            else
				self:setFillLevel(0, Fillable.FILLTYPE_UNKNOWN);
		   end;
        end;
    end;
end;

function krokodyl:findUnloadTargetRaycastCallback(transformId, x, y, z, distance)
	local target = g_currentMission.objectToTrailer[transformId];
	if target  ~= nil then
		if target ~= self then
			if target.fillLevel < target.capacity and target.allowFillFromAir and target:allowFillType(self.currentFillType) then
				self.targetFound = transformId;
			end;
		end;
	end;
end;

function krokodyl:onEndTip()
end;
function krokodyl:onStartTip()
end;

function krokodyl:checkForTipTriggers(self)
	if g_currentMission.trailerTipTriggers[self] ~= nil then
		local triggers = g_currentMission.trailerTipTriggers[self];
		for i,trigger in pairs(triggers) do
			if trigger.acceptedFruitTypes[FruitUtil.fillTypeToFruitType[self.currentFillType]] ~= nil and trigger.isEnabled then
				if trigger.isFarmTrigger then
					g_currentMission:setSiloAmount(self.currentFillType, g_currentMission:getSiloAmount(self.currentFillType)+self.transfer);
					return true;
				elseif trigger.priceMultipliers ~= nil then
					local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
					if fruitType ~= nil then
						local priceMultiplier = trigger.priceMultipliers[fruitType];
						local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
						local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * priceMultiplier * difficultyMultiplier * self.transfer;
						g_currentMission:addSharedMoney(money);
					end;
					if self.transfer > 0 then
						trigger:updateMoving(self.transfer);
					end;
					return true;
				end;
			end;
		end;
	end;
	return false;
end;

function krokodyl:checkForTrailers(self)
	self.targetFound = nil;
	local x,y,z = getWorldTranslation(self.shovelTipReferenceNode);
	raycastAll(x, y, z, 0, -1, 0, "findUnloadTargetRaycastCallback", 10, self);
	if self.targetFound ~= nil then
		local trailer = g_currentMission.objectToTrailer[self.targetFound];
		trailer:resetFillLevelIfNeeded(self.currentFillType);
		self.transfer = math.min(self.transfer, (trailer.capacity - trailer.fillLevel) );
		trailer:setFillLevel(trailer.fillLevel + self.transfer, self.currentFillType);
		return true;
	end;
	return false;
end;

function krokodyl:checkForMMSTrigger(self)
	if g_currentMission.modMapShovelTrigger ~= nil then
		local x,y,z = getWorldTranslation(self.shovelTipReferenceNode);
		for i,trigger in ipairs(g_currentMission.modMapShovelTrigger) do
			local xt,yt,zt = getWorldTranslation(trigger.emptyNode);
			local dist = Utils.vector3Length(x-xt, y-yt, z-zt);
			if dist < 5.0 then
				if trigger.fillLevel < trigger.capacity and trigger:allowFillType(self.currentFillType, true) then
					self.transfer = math.min(self.transfer, (trigger.capacity - trigger.fillLevel) );
					trigger:setFillLevel(trigger.fillLevel + self.transfer, self.currentFillType);
					return true;
				end;
			end;
		end;
	end;
	return false;
end;

function krokodyl:checkForAlternativeTipping(self)
	if not g_currentMission.alternativeTipTrigger then
		self.transfer = 0;
		return false;
	end;
	if g_currentMission.alternativeTipTrigger:getTriggerByFilltype(Fillable.fillTypeIntToName[self.currentFillType]) ~= nil and self.tipState == Trailer.TIPSTATE_CLOSED then
		local allowed = true;
		local tcnt = 0;
		local x1,y1,z1 = getWorldTranslation(self.triggerPlacement);
		for _, trigger in pairs(g_currentMission.tipTriggers) do
			if trigger.isExtendedTrigger then
				tcnt = tcnt + 1;
				if tcnt >= self.maxHeaps then
					self:allowAltTipping(false);
					self.tooMuchAltTipping = true;
				end;
				if trigger.currentFillType ~= self.currentFillType then
					local x2,y2,z2 = getWorldTranslation(trigger.triggerId);
					local distance = Utils.vector2Length(x2-x1,z2-z1);
					if distance < 10 then
						allowed = false;
					end;
				end;
			end;
		end;	
		if allowed then
			local rn = self.rootNode;
			self.rootNode = self.attacherVehicle.rootNode;
			g_currentMission.alternativeTipTrigger:addNewTrigger(self, false, false);
			self.rootNode = rn;
		end;
	end;
	self.transfer = 0;
end;
		
function krokodyl:isCallbackValid(transformId)
	if getRigidBodyType(transformId) == "Kinematic" then
		return false;
	end;
end;

function krokodyl:allowAltTipping(allow, noEventSend)
	local tcnt = 0;
	for _, trigger in pairs(g_currentMission.tipTriggers) do
		if trigger.isExtendedTrigger then
			tcnt = tcnt+1;
		end;
	end;
	if tcnt < self.maxHeaps then
		self.tooMuchAltTipping = false;
		self.altTippingAllowed = allow;
		krokodylEvent.sendEvent(self,allow,noEventSend);
	else
		self.tooMuchAltTipping = true;
		self.altTippingAllowed = false;
		krokodylEvent.sendEvent(self,false,noEventSend);
	end;
end;

krokodylEvent = {};
krokodylEvent_mt = Class(krokodylEvent, Event);
InitEventClass(krokodylEvent, "krokodylEvent");

function krokodylEvent:emptyNew()
    local self = Event:new(krokodylEvent_mt);
    self.className="krokodylEvent";
    return self;
end;

function krokodylEvent:new(object, allow)
		local self = krokodylEvent:emptyNew()
		self.object = object;
		self.allow = allow;
		return self;
end;

function krokodylEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.allow  = streamReadBool(streamId);
    self:run(connection);
end;

function krokodylEvent:writeStream(streamId, connection)
    		streamWriteInt32(streamId, networkGetObjectId(self.object));
		streamWriteBool(streamId, self.allow);
end;

function krokodylEvent:run(connection)
	self.object:allowAltTipping(self.allow, true);
	if not connection:getIsServer() then
	    g_server:broadcastEvent(krokodylEvent:new(self.object, self.allow), nil, connection, self.object);
	end;	
end;

function krokodylEvent.sendEvent(object, allow, nes)
	if nes == nil or nes == false then
		if g_server ~= nil then
			g_server:broadcastEvent(krokodylEvent:new(object, allow), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(krokodylEvent:new(object, allow));
		end;
	end;
end;
