--
-- Ursus_5314_by_Tomy
-- Specialization for Ursus_5314_by_Tomy
--
-- @author  	Manuel Leithner (SFM-Modding) edit Lipa
-- @version 	v2.0
-- @date  		11/11/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

Vehicle.registerJointType("attachableFrontloader");

Ursus_5314_by_Tomy = {};

function Ursus_5314_by_Tomy.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus_5314_by_Tomy:load(xmlFile)
	
	-- Defines attributes of backHydraulic
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
	
	self.fenders = {};
	self.fenders.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index2"));
	
	self.updateJoint = false;
	--self.attacherJoints[2].jointType = Vehicle.JOINTTYPE_ATTACHABLEFRONTLOADER;
	setVisibility(self.fenders.left, true);
	setVisibility(self.fenders.right, true);
end;

function Ursus_5314_by_Tomy:delete()
end;

function Ursus_5314_by_Tomy:readStream(streamId, connection)
end;

function Ursus_5314_by_Tomy:writeStream(streamId, connection)
end;

function Ursus_5314_by_Tomy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ursus_5314_by_Tomy:keyEvent(unicode, sym, modifier, isDown)
end;

function Ursus_5314_by_Tomy:update(dt)
	if self:getIsActive() then
		-- update steeringbar
		Cylindered.updateMovingPart(self, self.movingParts[1]);		
		Cylindered.updateMovingPart(self, self.movingParts[2]);	
	end;
end;

function Ursus_5314_by_Tomy:updateTick(dt)

	if self:getIsActive() then	

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

function Ursus_5314_by_Tomy:draw()	
end;

function Ursus_5314_by_Tomy:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_ATTACHABLEFRONTLOADER then
		if jointIndex == 2 then
			setVisibility(self.fenders.left, false);
			setVisibility(self.fenders.right, false);
		end;
	end;
	self.updateJoint = true;
	
end;

function Ursus_5314_by_Tomy:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 2 then
		setVisibility(self.fenders.left, true);
		setVisibility(self.fenders.right, true);
	end;
end;

function Ursus_5314_by_Tomy:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function Ursus_5314_by_Tomy:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function Ursus_5314_by_Tomy:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;