-- SwitchingWeightModes
-- Specialization for SwitchingWeightModes
--
-- @author Lipa
-- @date 04/09/2011
--


SwitchingWeightModes = {};

function SwitchingWeightModes.prerequisitesPresent(specializations)
    return true;
end;

function SwitchingWeightModes:load(xmlFile)	
    self.setWeightSelectionGroup = SpecializationUtil.callSpecializationsFunction("setWeightSelectionGroup");

	local inputKeystr = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SwitchingWeightModes#switchWeightModeKey"), "IMPLEMENT_EXTRA");
	self.switchWeightModeKey = InputBinding[inputKeystr];
	
	self.weightVisibility = {};
    local i = 0;
    while true do
		local key = string.format("vehicle.SwitchingWeightModes.registerWeight(%d)", i);
		local index = getXMLString(xmlFile, key.."#index");
		local weightId = getXMLString(xmlFile, key.."#weightId");
		if index ~= nil and weightId ~= nil then
			local entry = {};
			entry.node = Utils.indexToObject(self.components, index);
			setVisibility(entry.node, false);
			entry.weightId = weightId;
			table.insert(self.weightVisibility, entry);
		else
			break;
		end;
		i = i + 1;
	end;
	
	self.weightSelectionGroups = {};
	i = 0;
    while true do
		local key = string.format("vehicle.SwitchingWeightModes.registerWeightSelectionGroup(%d)", i);
		local weightIdsStr = getXMLString(xmlFile, key.."#weightIds");
		local nextWeightSelectionGroupRenderTextStr = getXMLString(xmlFile, key.."#nextWeightSelectionGroupRenderText");
		if weightIdsStr ~= nil and nextWeightSelectionGroupRenderTextStr ~= nil then
			local entry = {}; 
			entry.weightIds = {};
			local weightIds = Utils.splitString(" ", weightIdsStr);
			for k,v in pairs(weightIds) do
				for a,b in pairs(self.weightVisibility) do
					if v == b.weightId then						
						table.insert(entry.weightIds, b.weightId);
					end;
				end;
			end;
			entry.nextWeightSelectionGroupRenderText = g_i18n:getText(nextWeightSelectionGroupRenderTextStr)
			table.insert(self.weightSelectionGroups, entry);
		else
			break;
		end;
		i = i + 1;
	end;
	self.currentSelectedGroup = 0;
	self.startSelectedGroup = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.SwitchingWeightModes.normalWeightSelectionGroup#weightInteger"), 1);
	self.backupMass = getMass(self.components[1].node);
	
end;

function SwitchingWeightModes:delete()
end;

function SwitchingWeightModes:readStream(streamId, connection)
	local newSelectedGroup = streamReadInt8(streamId);
	if newSelectedGroup ~= self.currentSelectedGroup then
		self:setWeightSelectionGroup(newSelectedGroup, true);
	end;
end;

function SwitchingWeightModes:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentSelectedGroup);
end;

function SwitchingWeightModes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SwitchingWeightModes:keyEvent(unicode, sym, modifier, isDown)
end;

function SwitchingWeightModes:update(dt)
	if not self.loadedStartWeights then
		self:setWeightSelectionGroup(self.startSelectedGroup, true);
		self.loadedStartWeights = true;
	end;
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(self.switchWeightModeKey) then
			local newSelectedGroup = self.currentSelectedGroup + 1;
			if newSelectedGroup > table.getn(self.weightSelectionGroups) then
				newSelectedGroup = 1;
			end;
			self:setWeightSelectionGroup(newSelectedGroup);
		end;
	end;
end;

function SwitchingWeightModes:updateTick(dt)
end;

function SwitchingWeightModes:draw()
	self.waga = getMass(self.components[1].node);
	if self.currentSelectedGroup > 0 then
		g_currentMission:addHelpButtonText(self.weightSelectionGroups[self.currentSelectedGroup].nextWeightSelectionGroupRenderText, self.switchWeightModeKey);
	end;
end;

function SwitchingWeightModes:setWeightSelectionGroup(newSelectedGroup, noEventSend)
	SetWeightSelectionGroupEvent.sendEvent(self, newSelectedGroup, noEventSend);
	local firstSetAllInvisible = true;
	if firstSetAllInvisible then
		for c,d in pairs(self.weightVisibility) do
			if getVisibility(d.node) then
				setVisibility(d.node, false);
			end;
		end;
		firstSetAllInvisible = false;
	end;
	for k,v in pairs(self.weightSelectionGroups) do
		if k == newSelectedGroup then
			for a,b in pairs(v.weightIds) do
				for c,d in pairs(self.weightVisibility) do
					if b == d.weightId then
						setVisibility(d.node, true);
					end;
				end;
			end;
		end;
	end;
	self.currentSelectedGroup = newSelectedGroup;
	
	self.emptyMass = getMass(self.components[1].node);

	if self.currentSelectedGroup == 1 then
		setMass(self.components[1].node, 9.282);
		setCenterOfMass(self.components[1].node, 0, -2.1, 0.2);
	elseif self.currentSelectedGroup == 2 then
		setMass(self.components[1].node, self.emptyMass + 1);
		setCenterOfMass(self.components[1].node, 0, -2.1, 0.2);
	elseif self.currentSelectedGroup == 3 then
		setMass(self.components[1].node, self.emptyMass + 2);
		setCenterOfMass(self.components[1].node, 0, -2.1, 0.2);
	elseif self.currentSelectedGroup == 4 then
		setMass(self.components[1].node, self.emptyMass + 3);
		setCenterOfMass(self.components[1].node, 0, -2.1, 0.2);
	end;
end;

function SwitchingWeightModes:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local weightSelectionGroup = getXMLInt(xmlFile, key.."#weightSelectionGroup");
		if weightSelectionGroup > 0 and weightSelectionGroup <= table.getn(self.weightSelectionGroups) then
			self:setWeightSelectionGroup(weightSelectionGroup, true)
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function SwitchingWeightModes:getSaveAttributesAndNodes(nodeIdent)
	if self.currentSelectedGroup > 0 then
		local attributes = 'weightSelectionGroup="' .. tostring(self.currentSelectedGroup) ..'"';
		return attributes, nil;
	end;
end;