

MF8140 = {}

function MF8140.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MF8140:load(xmlFile)
	-- Interactive Button --
	-- Wiper --
	self.setNewLightsVisibility = SpecializationUtil.callSpecializationsFunction("setNewLightsVisibility");	
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	-- New corona --
	local numNewLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.newLights#count"), 0);
    self.newLights = {};
    for i=1, numNewLights do
        local lightnamei = string.format("vehicle.newLights.newLight%d", i);
		self.newLights[i] = {};
        self.newLights[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#index"));
        setVisibility(self.newLights[i].node, false);
    end;
	
	self.newStandardLightActive = false;
	self.newFrontLight1Active = false;
	self.newFrontLight2Active = false;
	self.newBackLight1Active = false;
	self.newBackLight2Active = false;
	
	self.lowerBack = false;
	self.lowerFront = false;	
	
	local indicatorFuel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.indicatorFuel#index"));
    if indicatorFuel ~= nil then
        self.indicatorFuel = {};
        self.indicatorFuel.node = indicatorFuel;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.indicatorFuel#minRot"));
        self.indicatorFuel.minRot = {};
        self.indicatorFuel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.indicatorFuel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.indicatorFuel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.indicatorFuel#maxRot"));
        self.indicatorFuel.maxRot = {};
        self.indicatorFuel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.indicatorFuel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.indicatorFuel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;  	
	local indicatorRPM = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.indicatorRPM#index"));
    if indicatorRPM ~= nil then
        self.indicatorRPM = {};
        self.indicatorRPM.node = indicatorRPM;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.indicatorRPM#minRot"));
        self.indicatorRPM.minRot = {};
        self.indicatorRPM.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.indicatorRPM.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.indicatorRPM.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.indicatorRPM#maxRot"));
        self.indicatorRPM.maxRot = {};
        self.indicatorRPM.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.indicatorRPM.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.indicatorRPM.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;  
end;
function MF8140:delete()
end;
function MF8140:readStream(streamId, connection)
	self:setNewLightsVisibility(streamWriteBool(streamId), true);
end;
function MF8140:writeStream(streamId, connection)
	streamWriteBool(streamId, self.newStandardLightActive);
	streamWriteBool(streamId, self.newFrontLight1Active);
	streamWriteBool(streamId, self.newFrontLight2Active);
	streamWriteBool(streamId, self.newBackLight1Active);
	streamWriteBool(streamId, self.newBackLight2Active);
	streamWriteBool(streamId, self.isWiperActive);
end;
function MF8140:readUpdateStream(streamId, timestamp, connection)
end;
function MF8140:writeUpdateStream(streamId, connection, dirtyMask)
end;
function MF8140:mouseEvent(posX, posY, isDown, isUp, button)
end;
function MF8140:keyEvent(unicode, sym, modifier, isDown)
end;
function MF8140:update(dt)
end;
function MF8140:updateTick(dt)
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;

		if self.indicatorFuel ~= nil then
			local x, y, z = getRotation(self.indicatorFuel.node);
			y = ((self.indicatorFuel.maxRot[2] - self.indicatorFuel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.indicatorFuel.minRot[2];
			setRotation(self.indicatorFuel.node, x, y ,z);
		end;
		if self.indicatorRPM ~= nil then
			local x, y, z = getRotation(self.indicatorRPM.node);
			y = ((self.indicatorRPM.maxRot[2] - self.indicatorRPM.minRot[2]) / self.motor.maxRpm[3]) * self.motor.lastMotorRpm + self.indicatorRPM.minRot[2];
			setRotation(self.indicatorRPM.node, x, y ,z);
		end;
	end;
end;
function MF8140:draw()
end;

function MF8140:setNewLightsVisibility(num, visibility, noEventSend)
	if num == 1 then
		if visibility ~= self.newFrontLight1Active then	
			self.newFrontLight1Active = visibility;
			setVisibility(self.newLights[1].node, visibility);	
		end;
	end;	
	if num == 2 then
		if visibility ~= self.newFrontLight2Active then	
			self.newFrontLight2Active = visibility;
			setVisibility(self.newLights[2].node, visibility);	
		end;
	end;
	if num == 3 then
		if visibility ~= self.newBackLight1Active then	
			self.newBackLight1Active = visibility;
			setVisibility(self.newLights[3].node, visibility);	
		end;
	end;
	if num == 4 then
		if visibility ~= self.newStandardLightActive then	
			self.newStandardLightActive = visibility;
			setVisibility(self.newLights[4].node, visibility);	
		end;
	end;	
	if num == 5 then
		if visibility ~= self.newBackLight2Active then	
			self.newBackLight2Active = visibility;
			setVisibility(self.newLights[5].node, visibility);	
		end;
	end;
end;

function MF8140:onLeave()
	for i=1, table.getn(self.newLights) do
		setVisibility(self.newLights[i].node, false);		
	end;
end;