--
-- Dynashift
-- specialization for MF_8110
-- Autor : Templear (autoquad)
-- 

Dynashift = {}

function Dynashift.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Dynashift:load(xmlFile)
	self.setLevel = SpecializationUtil.callSpecializationsFunction("setLevel");
	self.setRange = SpecializationUtil.callSpecializationsFunction("setRange");

	self.numRanges = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numRanges#count"), 4);
	self.numLevels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numLevels#count"), 6);
	self.currentLevel = 1;
    self.currentRange = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startingRange#number"), 3), self.numRanges) - 1;
	
	local totalGears = self.numRanges * self.numLevels;
	local totalFieldGears = (self.numRanges - 1) * self.numLevels;
	local stepSize = self.motor.maxRpm[3] / totalGears;
	local correctionDown = (self.motor.maxRpm[3] / 2) / (totalFieldGears * stepSize);
	local correctionUp = 0.95 - correctionDown;
	
	self.rpmTable = {};
	for i = 0, self.numLevels-1 do
		self.rpmTable[i] = {}; 
		for j = 0, self.numRanges-1 do
			local currentRpm = (i * (self.motor.maxRpm[3] / self.numLevels) + (j+1) * self.motor.maxRpm[3] / self.numLevels / self.numRanges);
			if i < self.numLevels - 1 then	
				self.rpmTable[i][j] = currentRpm * correctionDown;
			else
				self.rpmTable[i][j] = currentRpm * (correctionUp + ((1 - correctionUp) / self.numRanges) * (j+1));
			end;
		end;
	end;
	
	
	self.HudX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.Hud#posX"), 0.7543);
	self.HudY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.Hud#posY"), 0.1715);
	
	self.HudOverlay = Overlay:new("hudOverlay", Utils.getFilename("dynashift_hud.dds", self.baseDirectory), self.HudX, self.HudY, 0.2371, 0.039525);
end;
function Dynashift:delete()
end;
function Dynashift:readStream(streamId, connection)
   self:setLevel(streamReadInt8(streamId), true);
   self:setRange(streamReadInt8(streamId), true);
end;
function Dynashift:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numRanges);
	streamWriteInt8(streamId, self.numLevels);	
	streamWriteInt8(streamId, self.currentLevel);
	streamWriteInt8(streamId, self.currentRange);
end;
function Dynashift:readUpdateStream(streamId, timestamp, connection)
end;
function Dynashift:writeUpdateStream(streamId, connection, dirtyMask)
end;
function Dynashift:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Dynashift:keyEvent(unicode, sym, modifier, isDown)
end;
function Dynashift:update(dt)
	if self:getIsActiveForInput() then
		if not self.isMouseActive then
			if InputBinding.hasEvent(InputBinding.RANGEUP) then
				self:setRange(1);
			end;
			
			if InputBinding.hasEvent(InputBinding.RANGEDOWN) then
				self:setRange(-1);
			end;
				
			if InputBinding.hasEvent(InputBinding.LEVELUP) then
				self:setLevel(1);
			end;
			
			if InputBinding.hasEvent(InputBinding.LEVELDOWN) then
				self:setLevel(-1);
			end;
		end;
	end;

end;
function Dynashift:updateTick(dt)
	self.motor.maxRpm[3] = self.rpmTable[self.currentLevel-1][self.currentRange];		
end;
function Dynashift:draw()
	self.HudOverlay:render();
	renderText(self.HudX + 0.125, self.HudY + 0.012, 0.015, string.format("Level/Range : %2d/%c", self.currentLevel, self.currentRange+65));
--	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("RANGE"), self.typeDesc));
--	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("LEVEL"), self.typeDesc));
end;
function Dynashift:onLeave()
end;

function Dynashift:setLevel(direction, noEventSend)
	SetLevelEvent.sendEvent(self, direction, noEventSend);
	if direction == 1 and self.currentLevel < self.numLevels or direction == -1 and self.currentLevel > 1 then
		self.currentLevel = self.currentLevel + direction;
	end;
	--self.motor.maxRpm[3] = self.rpmTable[self.currentLevel-1][self.currentRange];	
end;

function Dynashift:setRange(direction, noEventSend)
	SetRangeEvent.sendEvent(self, direction, noEventSend);
	if direction == 1 and self.currentRange < self.numRanges - 1 or direction == -1 and self.currentRange > 0 then
		self.currentRange = self.currentRange + direction;
	end;
	--self.motor.maxRpm[3] = self.rpmTable[self.currentLevel-1][self.currentRange];		
end;
