ManualIgnitionEvent = {};
ManualIgnitionEvent_mt = Class(ManualIgnitionEvent, Event);

InitEventClass(ManualIgnitionEvent, "ManualIgnitionEvent");

function ManualIgnitionEvent:emptyNew()
    local self = Event:new(ManualIgnitionEvent_mt);
    self.className="ManualIgnitionEvent";
    return self;
end;

function ManualIgnitionEvent:new(object, isRunning)
    local self = ManualIgnitionEvent:emptyNew()
    self.object = object;
	self.isRunning = isRunning;
    return self;
end;

function ManualIgnitionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRunning = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function ManualIgnitionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isRunning);
end;

function ManualIgnitionEvent:run(connection)
	self.object:invokeIgnition(self.isRunning);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ManualIgnitionEvent:new(self.object, self.isRunning), nil, connection, self.object);
    end;	
end;

function ManualIgnitionEvent.sendEvent(vehicle, isRunning)
	if g_server ~= nil then
		g_server:broadcastEvent(ManualIgnitionEvent:new(vehicle, isRunning), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(ManualIgnitionEvent:new(vehicle, isRunning));
	end;
end;

