--
-- variostar_760
-- Specialization for variostar_760 mod
--
-- @author  Tobias F. (John Deere 6930, 1. LS-Modschmiede)

variostar_760 = {};

function variostar_760.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function variostar_760:load(xmlFile)
    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
    end;	

	local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
end;

function variostar_760:delete()
end;

function variostar_760:mouseEvent(posX, posY, isDown, isUp, button)
end;

function variostar_760:keyEvent(unicode, sym, modifier, isDown)
end;

function variostar_760:update(dt)
    if self.attacherVehicle ~= nil then
		self.support_auto = false;
	end;
    if self.attacherVehicle == nil then
		self.support_auto = true;
	end;
	if self.support_auto ~= nil then
		local x, y, z = getRotation(self.rotationPart.node);
		local rot = {x,y,z};				
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.support_auto);
		setRotation(self.rotationPart.node, unpack(newRot));
		local x, y, z = getRotation(self.rotationPart2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.support_auto);
		setRotation(self.rotationPart2.node, unpack(newRot));
	end;	    
end;

function variostar_760:draw()
end;