MulcherAreaEvent = {};
MulcherAreaEvent_mt = Class(MulcherAreaEvent, Event);
  
InitEventClass(MulcherAreaEvent, "MulcherAreaEvent");
  
function MulcherAreaEvent:emptyNew()
    local self = Event:new(MulcherAreaEvent_mt);
    self.className="MulcherAreaEvent";
    return self;
end;
  
function MulcherAreaEvent:new(cuttingAreas, fruitType, mode)
    local self = MulcherAreaEvent:emptyNew()
    self.cuttingAreas = cuttingAreas;
	self.fruitType = fruitType;
	self.mode = mode;
    return self;
end;
  
function MulcherAreaEvent:readStream(streamId, connection)
    local numAreas = streamReadUIntN(streamId, 4);
    local fruitType = streamReadInt8(streamId);
	local mode = streamReadInt8(streamId);
	local refX = streamReadFloat32(streamId);
    local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
    for i=1,numAreas do
		local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
      if fruitType ~= nil then --mode 1 = auf Stufe eins ; mode 2 = fruit lschen - stoppeln lassen ; mode 3 = fruit lschen - stoppeln auch;
			if mode == 1 then
				local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
				setDensityMaskedParallelogram(g_currentMission.fruits[fruitType].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[fruitType].id, 0, 3, 2.0);
			end;
			if mode == 2 then
				Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
				Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
			end;
			if mode == 3 then
				Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
				Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 0);
				--if isWindrow then
					Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
					Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
				--end;
			end;
		end;
    end;
end;
   
function MulcherAreaEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteUIntN(streamId, numAreas, 4);
    streamWriteInt8(streamId, self.fruitType);
	streamWriteInt8(streamId, self.mode);
	local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
            streamWriteFloat32(streamId, d[1]);
            streamWriteFloat32(streamId, d[2]);
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);
    Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
end;
  
function MulcherAreaEvent:run(connection)
    print("Error: Do not run MulcherAreaEvent locally");
end;
 
function MulcherAreaEvent.runLocally(cuttingAreas, fruitType, mode)
     
    local numAreas = table.getn(cuttingAreas);
    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);
 
    local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
 
    for i=1, numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
        if fruitType ~= nil then --mode 1 = auf Stufe eins ; mode 2 = fruit lschen - stoppeln lassen ; mode 3 = fruit lschen - stoppeln auch;
			if mode == 1 then
				local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
				setDensityMaskedParallelogram(g_currentMission.fruits[fruitType].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[fruitType].id, 0, 3, 2.0);
			end;
			if mode == 2 then
				Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
				Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
			end;
			if mode == 3 then
				Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
				Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 0);
				--if isWindrow then
					Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
					Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
				--end;
			end;
		end;
    end;
end;