--
-- Maschio
--
-- @author  Stefan Geiger 
-- @date  11/05/08	   
--
-- Maschio Edit : [15.11.2011] - FIAT80-90DT
-- ###- ModdingStage - ###
 
Maschio = {};
  
function Maschio.prerequisitesPresent(specializations)
      return true;
end;
  
function Maschio:load(xmlFile)
  
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
   
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;      
    if self.isClient then
		local maschioSound = getXMLString(xmlFile, "vehicle.maschioSound#file");
		if maschioSound ~= nil and maschioSound ~= "" then
			maschioSound = Utils.getFilename(maschioSound, self.baseDirectory); 
			self.maschioSound = createSample("maschioSound");
			self.maschioSoundEnabled = false;
			loadSample(self.maschioSound, maschioSound, false);
			self.maschioSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.maschioSound#pitchOffset"), 1);
			self.maschioSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.maschioSound#volume"), 1);
		end;
	end;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;

	self.isTurnedOn = false;
	self.wasToFast = false;
	self.MaschioGroundFlag = self.nextDirtyFlag;
	self.nextDirtyFlag = self.MaschioGroundFlag*2;
	
	-- ps - ParticleSystem
	self.showParticle = false;
	self.particleSystems = {};
	local i = 0;
        while true do
            local key = string.format("vehicle.particleSystems.system(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;
            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};
				local index = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"));
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "particleSystems/dust.i3d", self.baseDirectory, index);
                self.particleSystems[desc.index] = currentPS;
				self.particleSystems.index = index;
            end;
        i = i + 1;
    end;
	
	self.dustParticle = {};
	self.showDust = false;
	local index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.particleSystems.dust#index"));
	Utils.loadParticleSystem(xmlFile, self.dustParticle, "vehicle.particleSystems.dust", self.components, false, nil, self.baseDirectory, index);
	
	self.fruitModes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.fruitModes.fruit(%d)", i);
		local name = getXMLString(xmlFile, key.."#name");
		if name == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[name];
		if desc ~= nil then
			local mode = Utils.getNoNil(getXMLInt(xmlFile, key.."#mode"), 3);
			if mode > 3 then
				print("Error : invalid fruitMode for "..tostring(name).." in "..tostring(self.name));
				mode = 3;
			end;
			self.fruitModes[desc.index] = mode;
		end;
		i = i+1;
	end;
end;

function Maschio:delete()  
	for fruitType,_ in pairs(g_currentMission.fruits) do
		Utils.setEmittingState(self.particleSystems[fruitType], false);
	end;
	
	if self.maschioSound ~= nil then
		delete(self.maschioSound);
	end;
end;
  
function Maschio:readStream(streamId, connection)
	local turnedOn = streamReadBool(streamId);
	self:setIsTurnedOn(turnedOn, true);
end;
 
function Maschio:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
end;
  
function Maschio:readUpdateStream(streamId, timestamp, connection)
end;
  
function Maschio:writeUpdateStream(streamId, connection, dirtyMask)
end;
  
function Maschio:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function Maschio:keyEvent(unicode, sym, modifier, isDown)
end;

function Maschio:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
	end;
end;

function Maschio:updateTick(dt)	
	if self.movingDirection < 0 then -- reverse --
		setRotation(self.particleSystems.index, 0, 180, 0);
	else
		setRotation(self.particleSystems.index, 0, 0, 0);
	end;
	
	self.wasToFast = false;
	self.showParticle = false;
	
	local rain = g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30;
	
	if self:getIsActive() then
		if self.isTurnedOn then			
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
			if not toFast then 
				if self.isServer then
					local x,y,z = getWorldTranslation(self.groundReferenceNode);
	                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
	                if terrainHeight+self.groundReferenceThreshold >= y then
						if (self.lastSpeed*3600)> 1 then
							if self:getRealAnimationTime("chain") == 0 then
								self:playAnimation("chain", 1, nil);
							elseif self:getRealAnimationTime("chain") == self:getAnimationDuration("chain") then
								self:playAnimation("chain", -1, nil);
							end;
						end;						
						
						local cuttingAreasSend = {};
						local mode = 1;
						for k, cuttingArea in pairs(self.cuttingAreas) do
							if self:getIsAreaActive(cuttingArea) then
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
								--Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
								-- Particle System & fruitTypeCheck -- 
								for fruitType,_ in pairs(g_currentMission.fruits) do
									local checkFruit = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
									local checkWindrow = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
									local checkCutLong = Utils.getFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2);
									
									if checkFruit > 0 or checkWindrow > 0 or checkCutLong > 0 then
										mode = self.fruitModes[fruitType];
										if checkFruit < 0 then
											mode = 3;
										end;
										self.fruitType = fruitType;
										self.showParticle = true;
									end;
								end;
							end;
						end;
						if (table.getn(cuttingAreasSend) > 0) then
							--MowerAreaEvent.runLocally(cuttingAreasSend);
							--g_server:broadcastEvent(MowerAreaEvent:new(cuttingAreasSend));
							MulcherAreaEvent.runLocally(cuttingAreasSend, self.fruitType, mode);
							g_server:broadcastEvent(MulcherAreaEvent:new(cuttingAreasSend, self.fruitType, mode));
						end;
						self.showDust = true;
					else
						self.showDust = false;
					end;
				end;
			end;
			if self.isClient then
				if not self.maschioSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.maschioSound, self.maschioSoundPitchOffset);
					playSample(self.maschioSound, 0, self.maschioSoundVolume, 0);
					self.maschioSoundEnabled = true;
				end;
			end;
	
			self.wasToFast = toFast;
			if self.attacherVehicle.motor ~= nil then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -750);
			end;
		else
			if self.attacherVehicle.motor ~= nil then
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.backupMinRpm);
			end;
			if self.isClient then
				if self.maschioSoundEnabled then
					stopSample(self.maschioSound);
					self.maschioSoundEnabled = false;
				end;
			end;
		end;
	end;
	
	if self.fruitType ~= self.backupFruittype then
		for fruitType,_ in pairs(g_currentMission.fruits) do
			Utils.setEmittingState(self.particleSystems[fruitType], false);
		end;
		self.backupFruitType = self.fruitType;
	end;
	if self.movingDirection ~= 0 then
		Utils.setEmittingState(self.particleSystems[self.fruitType], self.showParticle);
	end;
	
	Utils.setEmittingState(self.dustParticle, (rain and self.isTurnedOn and self.showDust));
end;

function Maschio:draw()
	g_currentMission:addExtraPrintText(g_i18n:getText("MASCHIO_MOVE"));
	if self.isClient then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
			
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
		end;
		if self.wasToFast then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
		end;
	end;
end;

function Maschio:onAttach(attacherVehicle)
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.backupMinRpm = self.attacherVehicle.motor.minRpm;
	else
		print("No motorized AttacherVehicle!")
	end;
end;

function Maschio:onDetach()
	
	Utils.setEmittingState(self.dustParticle, false);
	for fruitType,_ in pairs(g_currentMission.fruits) do
		Utils.setEmittingState(self.particleSystems[fruitType], false);
	end;
	
	if self.deactivateOnDetach then
		Maschio.onDeactivate(self);
	else
		Maschio.onDeactivateSounds(self)
	end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.backupMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end

function Maschio:onLeave()
	Utils.setEmittingState(self.dustParticle, false);
	if self.deactivateOnLeave then
		Maschio.onDeactivate(self);
	else
		Maschio.onDeactivateSounds(self)
	end;
end;

function Maschio:onDeactivate()
	Utils.setEmittingState(self.dustParticle, false);
	for fruitType,_ in pairs(g_currentMission.fruits) do
		Utils.setEmittingState(self.particleSystems[fruitType], false);
	end;
	
	self:playAnimation("chain", -1, nil);
	Maschio.onDeactivateSounds(self)
	self.isTurnedOn = false;
end;

function Maschio:onDeactivateSounds()
	if self.isClient then
		if self.maschioSoundEnabled then
			stopSample(self.maschioSound);
			self.maschioSoundEnabled = false;
		end;
	end;
end;

function Maschio:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
end;