
--
-- ChangeCouplingPoint
-- Desc
--
-- @author  FIAT80-90DT (old Powershaft by Face!)
-- @date  	15.11.2011
--
-- ###- ModdingStage - ### - DO NOT EDIT ### --

ChangeCouplingPoint = {};

function ChangeCouplingPoint.prerequisitesPresent(specializations)
    return true;
end;

function ChangeCouplingPoint:load(xmlFile)
	self.setCouplingPoint = SpecializationUtil.callSpecializationsFunction("setCouplingPoint");
	
--#### Powershaft ###--
	
	self.powerShaftNew = {};
	self.powerShaftNewCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.powerShafts#count"), 0);
	for i=1, self.powerShaftNewCount do 
		self.powerShaftNew[i] = {};
		local str = string.format("vehicle.powerShafts.powerShaft%d", i);
		
		self.powerShaftNew[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#index"));
		local x,y,z = getRotation(self.powerShaftNew[i].node);
		self.powerShaftNew[i].rot = {x,y,z};
		self.powerShaftNew[i].part = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#part"));
		x,y,z = getTranslation(self.powerShaftNew[i].part);
		self.powerShaftNew[i].trans = {x,y,z};
		self.powerShaftNew[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#fixPoint"));
		local ax, ay, az = getWorldTranslation(self.powerShaftNew[i].part);
		local bx, by, bz = getWorldTranslation(self.powerShaftNew[i].fixPoint);		
		self.powerShaftNew[i].distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;
	
	self.powerShaft = self.powerShaftNew[1];
	
	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;
----------------------

--## UPDATE ATTACHER JOINTS ##--
	self.couplingPointCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.attacherJoints#count"), 0);
	self.couplingPoint = {};
	for i=1, self.couplingPointCount do 
		self.couplingPoint[i] = {};
		
		local str = string.format("vehicle.attacherJoints.attacherJoint%d", i);
		
		self.couplingPoint[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#index"));
		if self.couplingPoint[i].node ~= nil then			
			self.couplingPoint[i].topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#topReferenceNode"));
			self.couplingPoint[i].rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#rootNode")), self.components[1].node);
			self.couplingPoint[i].fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, str.."#fixedRotation"), false);
	  
			self.couplingPoint[i].allowsJointRotLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, str.."#allowsJointRotLimitMovement"), true);
			self.couplingPoint[i].allowsJointTransLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, str.."#allowsJointTransLimitMovement"), true);
	  
			--load joint limit scales
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  str.."#rotLimitScale"));
			self.couplingPoint[i].rotLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  str.."#transLimitScale"));
			self.couplingPoint[i].transLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };

			local jointTypeStr = getXMLString(xmlFile, str.."#jointType")
			local jointType;
			
			if jointTypeStr ~= nil then
				jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
				if jointType == nil then
					print("Warning: invalid jointType " .. jointTypeStr);
				end;
			else
				print("Warning: missing jointType");
			end;
			if jointType == nil then
				local needsTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, str.."#needsTrailerJoint"), false);
				local needsLowTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, str.."#needsLowJoint"), false);
				if needsTrailerJoint then
					if needsLowTrailerJoint then
						jointType = Vehicle.JOINTTYPE_TRAILERLOW;
					else
						jointType = Vehicle.JOINTTYPE_TRAILER;
					end;
				else
					jointType = Vehicle.JOINTTYPE_IMPLEMENT;
				end;
			end;
			self.couplingPoint[i].jointType = jointType;
		end;
	end;

   self.attacherJoint = self.couplingPoint[1];
-----------------------

--####General Variables ###--
	self.curCouPoint = 1;
	self.isAttached = false;
-----------------------------


--####   Tubes    ###--
	self.tubesCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.tubes#count"), 0);
	self.tube = {};
	self.tube.main = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.tubes#detached"));
	for i=1, self.tubesCount do
		local str = string.format("vehicle.tubes.tube%d", i)
		self.tube[i] = {};
		self.tube[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#index"));
	end;
	self.curTube = self.tube[1];
-------------------------

--####  Trigger   ###--
	self.triggerCallback = ChangeCouplingPoint.triggerCallback;
	self.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trigger#node"));	
	addTrigger(self.node, "triggerCallback", self);
	self.deleteListenerId = addDeleteListener(self.node, "delete", self);
	self.isPlayerInRange = false;
------------------------	
end;

function ChangeCouplingPoint:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onStay then -- without onEnter?
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
			self.isPlayerInRange = true;
		end;
	else
		self.isPlayerInRange = false;
	end;
end;

function ChangeCouplingPoint:onAttach(attacherVehicle)
	-- tubes --
	setVisibility(self.curTube.index, true)
	setVisibility(self.tube.main, false);
	
	self.doJointSearch = true; --powershaft
	
	self.isAttached = true;
end;

function ChangeCouplingPoint:onDetach()
	-- tubes -- 
	setVisibility(self.tube.main, true);
	for i=1, self.tubesCount do
		setVisibility(self.tube[i].index, false);	
	end;	
	-- powershaft --
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
	
	self.isAttached = false;
end;

function ChangeCouplingPoint:delete()
	removeTrigger(self.node);
    removeDeleteListener(self.node, self.deleteListenerId);
end;

function ChangeCouplingPoint:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChangeCouplingPoint:readStream(streamId, connection)
	self:setCouplingPoint(streamReadInt8(streamId), true);
end;
 
function ChangeCouplingPoint:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.curCouPoint);
end;

function ChangeCouplingPoint:keyEvent(unicode, sym, modifier, isDown)
end;

function ChangeCouplingPoint:updateTick(dt)
end;

function ChangeCouplingPoint:update(dt)
-- powershaft --
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;	
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	
	if self:getIsActive() then		
			
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;		
	end;
----------------
	if self.isPlayerInRange then
		if not self.isAttached then
			g_currentMission:addHelpButtonText(g_i18n:getText("MASCHIO_CHANGE"), InputBinding.IMPLEMENT_EXTRA3);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3)then
				self.curCouPoint = self.curCouPoint+1;
				if self.curCouPoint > self.tubesCount then
					self.curCouPoint = 1;
				end;
				--print(self.curCouPoint)
				self:setCouplingPoint(self.curCouPoint);
			end;
		end;
	end;
end;

function ChangeCouplingPoint:draw()
end;

function ChangeCouplingPoint:setCouplingPoint(ccp, noEventSend)
	CouplingPointEvent.sendEvent(self, ccp, noEventSend)

	self.curCouPoint = ccp;
	self.attacherJoint = self.couplingPoint[ccp];
	self.powerShaft = self.powerShaftNew[ccp];
	self.curTube = self.tube[ccp];
	for i=1, self.powerShaftNewCount do
		setVisibility(self.powerShaftNew[i].node, false);
	end;
	setVisibility(self.powerShaft.node, true);
end;