--
-- Real World vs Playable Version 5.2
--
-- Copyright (C) Stormbringer

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;


function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
     
    -- load NEW CowArea by Blackburner
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));

    -- change prices and production for milk usw
    g_currentMission.milkProductionScale = 0.2;
    g_currentMission.milkPriceScale = 0.32;
    g_currentMission.manureProductionScale = 0.2;

    -- load archievements
    self:loadMap(Utils.getFilename("map01/achievements/achievements.i3d", self.baseDirectory));

    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

	haendlerpic = Utils.getFilename("pdasymbols/haendler.png", self.baseDirectory);
	brauereipic = Utils.getFilename("pdasymbols/jever.png", self.baseDirectory);
	muehlepic = Utils.getFilename("pdasymbols/giebelkreuz.png", self.baseDirectory);
	bgapic = Utils.getFilename("pdasymbols/bga.png", self.baseDirectory);
	hafenpic = Utils.getFilename("pdasymbols/anker.png", self.baseDirectory);
	tankepic = Utils.getFilename("pdasymbols/aral.png", self.baseDirectory);
	hofpic = Utils.getFilename("pdasymbols/hoflogo.png", self.baseDirectory);
	milchpic = Utils.getFilename("pdasymbols/milch.png", self.baseDirectory);
	blumenpic = Utils.getFilename("pdasymbols/flora.png", self.baseDirectory);
	parkppic = Utils.getFilename("pdasymbols/P.png", self.baseDirectory);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("agravis", haendlerpic, 1533, 1614, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Brauerei", brauereipic, 1773, 1675, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Muehle", muehlepic, 315, 780, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("bga", bgapic, 300, 1254, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("hafen", hafenpic, 1537, 1691, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("aral1", tankepic, 356, 1172, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("aral2", tankepic, 1299, 1108, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("hof1", hofpic, 1008, 700, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("molkerei", milchpic, 1382, 981, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("gaertnerei", blumenpic, 1499, 1473, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("parkplatzso", parkppic, 1243, 1693, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("parkplatzno", parkppic, 1661, 577, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("parkplatznw", parkppic, 420, 286, 0.025, 0.025, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("parkplatzsw", parkppic, 305, 1863, 0.025, 0.025, false, false, 0);


	-- load the Bottles in this Map / new by Blackburner
	self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
	
	--load Glass Containers
	self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));


    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
