--
--
--


-- Register fruits
function RegisterFruits()
	local fruitList = {};
    table.insert(fruitList, {type="fruit"   ,fruitName="blackbery"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="fruit"   ,fruitName="mohn"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="unknown" ,fruitName="minze"            ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="fruit"   ,fruitName="strawberies"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=3 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="lettuce" ,fruitName="egzoticpumpkins"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=5   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="lettuce" ,fruitName="blueberry"    ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=5   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );

    
    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "newfruit/images/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding   
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();

--
--
--
local origSowingMachineLoad = SowingMachine.load;
SowingMachine.load = function(self, xmlFile)
    if origSowingMachineLoad ~= nil then
        origSowingMachineLoad(self, xmlFile);
    end;

    --
    local msg = "Info. Added seeds to '".. Utils.getNoNil(self.name, "SowingMachine") .."': ";
    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        -- Check if FruitType have a FoliageSubLayer-/TerrainId.
        local terrainId = 0;
        if g_currentMission.fruits[fruitType.index] ~= nil then
            terrainId = g_currentMission.fruits[fruitType.index].id;
        end;
        -- Only add FruitType if its allowed to be seeded, AND have a FoliageSubLayer-/TerrainId.
        if fruitType.allowsSeeding and terrainId > 0 then
            table.insert(self.seeds, fruitType.index);
            msg = msg .. FruitUtil.fruitIndexToDesc[ fruitType.index ].name .." ";
        end;
    end;
    print(msg);
    -- Sort the seedable fruits by generic-name.
    table.sort(self.seeds, function(l,r) return (FruitUtil.fruitIndexToDesc[l].name < FruitUtil.fruitIndexToDesc[r].name); end);
end;
