--
-- WellbrookMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

WellbrookMap = {}

local WellbrookMap_mt = Class(WellbrookMap, Mission00);

function WellbrookMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = WellbrookMap_mt;
    end;
    local self = WellbrookMap:superClass():new(baseDirectory, mt);
    return self;
end;

function WellbrookMap:delete()
    WellbrookMap:superClass().delete(self);
end;

function WellbrookMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    Potato_Merchants = Utils.getFilename("map01/pdapics/business_park.png", self.baseDirectory);
    Grain_Merchants = Utils.getFilename("map01/pdapics/Grain_Merchants.png", self.baseDirectory);
	Farm_Shop = Utils.getFilename("map01/pdapics/farm_shop.dds", self.baseDirectory);
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
          
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow_passepartout.i3d", self.baseDirectory));
	
    g_currentMission.milkProductionScale = 0.5;
    g_currentMission.milkPriceScale = 1.0;
    g_currentMission.manureProductionScale = 0.5;
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	
	--Mission Glass Containers
    -- self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--Mission Bottles
    -- self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
 
 
 
 	-- PDA Hotspots
	
    self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 1392, 740, 0.025, 0.025, false, false, 0);
    self.missionPDA:createMapHotspot("Grain_Merchants", Grain_Merchants , 1360, 840 , 0.03, 0.03, false, false, 0);
    self.missionPDA:createMapHotspot("Potato_Merchants", Potato_Merchants , 330, 990 , 0.03, 0.03, false, false, 0);
	self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1208, 236, 0.036, 0.036, false, false, 0);
	self.missionPDA:createMapHotspot("Farming Shop", Farm_Shop , 510, 860, 0.065, 0.046, false, false, 0);
    
    WellbrookMap:superClass().load(self);
end
function WellbrookMap:loadFinished()
    WellbrookMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function WellbrookMap:mouseEvent(posX, posY, isDown, isUp, button)
    WellbrookMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function WellbrookMap:keyEvent(unicode, sym, modifier, isDown)
    WellbrookMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function WellbrookMap:update(dt)
    WellbrookMap:superClass().update(self, dt);
end;

function WellbrookMap:draw()
    WellbrookMap:superClass().draw(self);
end;
