RekordiaXXL = {};

function RekordiaXXL.prerequisitesPresent(specializations)
    return true;
end;

function RekordiaXXL:load(xmlFile)

	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.setTowballDirection = SpecializationUtil.callSpecializationsFunction("setTowballDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	for i=1, table.getn(self.cuttingAreas) do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].scale = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#scaleIndex"));
	end;

	self.sprayValvesSpray =  {};
	local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystemSpray#file");
	if psFile ~= nil then
		local i=0;
		while true do
			local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
			local node = getXMLString(xmlFile, baseName.. "#index");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local sprayValve = {};
				sprayValve.particleSystems = {};
				Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystemSpray", node, false, nil, self.baseDirectory);
				table.insert(self.sprayValvesSpray, sprayValve);
			end;
			i = i+1;
		end;
	end;
	
	self.attacherCylinder = {};
	self.attacherCylinder.leftCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinder"));
	self.attacherCylinder.leftPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderPunch"));
	self.attacherCylinder.leftFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderFixPoint"));
	if self.attacherCylinder.leftPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.leftFixPoint);
		self.attacherCylinder.leftDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.attacherCylinder.rightCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinder"));
	self.attacherCylinder.rightPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderPunch"));
	self.attacherCylinder.rightFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderFixPoint"));
	if self.attacherCylinder.rightPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.rightFixPoint);
		self.attacherCylinder.rightDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	
	self.holdPosition = {};
end;

function RekordiaXXL:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local i = 1;
		local componentKey = key..".component"..i;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, componentKey.."#position"));
		local xRot, yRot, zRot = Utils.getVectorFromString(getXMLString(xmlFile, componentKey.."#rotation"));
		self.holdPosition[i] = {x=x, y=y, z=z, xRot=xRot, yRot=yRot, zRot=zRot};
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function RekordiaXXL:delete()
	for k,sprayValve in pairs(self.sprayValvesSpray) do
		Utils.deleteParticleSystem(sprayValve.particleSystems);
	end;

end;

function RekordiaXXL:readStream(streamId, connection)

end;

function RekordiaXXL:writeStream(streamId, connection)

end;

function RekordiaXXL:mouseEvent(posX, posY, isDown, isUp, button)

end;

function RekordiaXXL:keyEvent(unicode, sym, modifier, isDown)

end;

function RekordiaXXL:update(dt)

	self:setTowballDirection();
	
	if table.getn(self.holdPosition) > 0 then
		local p = self.holdPosition[1];
		self:setWorldPosition(p.x,p.y,p.z, p.xRot,p.yRot,p.zRot, 1);
		self.holdPosition = {};
	end;

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].startPosition);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].startPosition);
			else
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
	end;
	
	if not self.isTurnedOn then
		if self.isSprayerFilling then
			self:setVehicleRpmUp(dt, true);
			if self.isClient then
				if not self.spraySoundEnabled and self:getIsActiveForSound() then
					playSample(self.spraySound, 0, self.spraySoundVolume, 0);
					setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
					self.spraySoundEnabled = true;
				end;
			end;
		else
			self:setVehicleRpmUp(dt, false);
			if self.spraySoundEnabled then
				stopSample(self.spraySound);
				self.spraySoundEnabled = false;
			end;
		end;
	end;

	
	if not self.animationParts[1].inputDone then
		self:setIsTurnedOn(false);
	end;
	
	local sprayParticleActive = self.isTurnedOn and self.animationParts[1].clipStartTime;
	for k, sprayValve in pairs(self.sprayValvesSpray) do
		Utils.setEmittingState(sprayValve.particleSystems, sprayParticleActive);
	end;
	if sprayParticleActive then
		for k,sprayValve in pairs(self.sprayValves) do
			Utils.setEmittingState(sprayValve.particleSystems, false);
		end;
	end;
	
	for k, area in pairs(self.cuttingAreas) do
		if self.animationParts[1].clipStartTime then
			setScale(area.scale, 0.65, 1, 1.1);
		else
			setScale(area.scale, 1, 1, 1);
		end;
	end;
	
	if self.updateSteeringAxleAngle then
		if self.attacherVehicle ~= nil and self.movingDirection < 0 then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 + (self.lastSpeed*-3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;
		end;
	end;
end;

function RekordiaXXL:updateTick(dt)
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;
end;

function RekordiaXXL:setTowballDirection()
	if self.leftFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftCylinder);
		local bx, by, bz = getWorldTranslation(self.leftFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.leftCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.leftCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.leftDistance ~= nil then
			setTranslation(self.attacherCylinder.leftPunch, 0, 0, distance-self.attacherCylinder.leftDistance);
		end;
	end;
	if self.rightFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightCylinder);
		local bx, by, bz = getWorldTranslation(self.rightFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.rightCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.rightCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.rightDistance ~= nil then
			setTranslation(self.attacherCylinder.rightPunch, 0, 0, distance-self.attacherCylinder.rightDistance);
		end;
	end;
end;

function RekordiaXXL:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function RekordiaXXL:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function RekordiaXXL:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function RekordiaXXL:draw()
	if self.animationParts[1].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Rekordia_3"), InputBinding.IMPLEMENT_EXTRA2);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Rekordia_2"), InputBinding.IMPLEMENT_EXTRA2);
	end;
	if self.animationParts[2].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Rekordia_5"), InputBinding.IMPLEMENT_EXTRA3);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Rekordia_4"), InputBinding.IMPLEMENT_EXTRA3);
	end;
end;