VarioTrailer = {};

function VarioTrailer.prerequisitesPresent(specializations)
    Vehicle.registerJointType("BergVarJoint");
	print("  register joint type: BergVarJoint");
	return true;
end;

function VarioTrailer:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.setTowballDirection = SpecializationUtil.callSpecializationsFunction("setTowballDirection");
	self.setAxlesOffset = SpecializationUtil.callSpecializationsFunction("setAxlesOffset");
	self.setLiftAxle = SpecializationUtil.callSpecializationsFunction("setLiftAxle");

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.attacherCylinder = {};
	self.attacherCylinder.leftCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinder"));
	self.attacherCylinder.leftPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderPunch"));
	self.attacherCylinder.leftFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderFixPoint"));
	if self.attacherCylinder.leftPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.leftFixPoint);
		self.attacherCylinder.leftDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.attacherCylinder.rightCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinder"));
	self.attacherCylinder.rightPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderPunch"));
	self.attacherCylinder.rightFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderFixPoint"));
	if self.attacherCylinder.rightPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.rightFixPoint);
		self.attacherCylinder.rightDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.towBallAngle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallAngle#index"));

	self.saveMinRpm = 0;

	self.axleCyls = {};
	self.axleCyls.start = getXMLFloat(xmlFile, "vehicle.axleCyls#start");
	self.axleCyls.value = getXMLFloat(xmlFile, "vehicle.axleCyls#start");
	self.axleCyls.fin = getXMLFloat(xmlFile, "vehicle.axleCyls#fin");
	self.axleCyls.finLift = getXMLFloat(xmlFile, "vehicle.axleCyls#finLift");
	self.axleCyls.duration = getXMLFloat(xmlFile, "vehicle.axleCyls#duration");
	self.axleCyls.cyls = {};
	i = 0;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.axleCyls.cyl(%d)#idx",i) ));
		if node == nil then 
			break;
		end;
		local entry = {};
		local joint = getXMLInt(xmlFile, string.format("vehicle.axleCyls.cyl(%d)#jointIdx",i) );
		entry.node = node;
		entry.joint = joint;
		table.insert(self.axleCyls.cyls, entry);
		i=i+1;
	end;
	
	self.axleSpringsRotMin = Utils.degToRad( getXMLFloat(xmlFile, "vehicle.axleSprings#rotMin") );
	self.axleSpringsRotMax = Utils.degToRad( getXMLFloat(xmlFile, "vehicle.axleSprings#rotMax") );
	self.axleSprings = {};
	i = 0;
	while true do 
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.axleSprings.spring(%d)#idx",i) ));
		if node == nil then 
			break;
		end;
		local entry = {};
		entry.node = node;
		table.insert(self.axleSprings, entry);
		i=i+1;
	end;	
	
	self.setLiftAxleUp = false;
	self.liftAxleIsDown = false;
	self.liftAxleIsUp = false;
	self.liftAxleValue = self.axleCyls.start;
	
	self.attacherJoints[1].jointType = Vehicle.JOINTTYPE_BERGVARJOINT;
	self.attacherJointBackup = self.attacherJoints[1];
	self.firstAttachOnLoad = false;
	self.firstAttachTime = 4000;
	
	self.attacherIsLocked = false;
	
	self.attAfterLoad = true;
end;

function VarioTrailer:delete()
end;

function VarioTrailer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local setLiftAxle = Utils.getNoNil(getXMLBool(xmlFile,key.."#setLiftAxle"));
		self:setLiftAxle(setLiftAxle, true);
		local axlesOffset = Utils.getNoNil(getXMLFloat(xmlFile,key.."#axleCyls.value"));
		self:setAxlesOffset(axlesOffset, true);
		
	end;
end;

function VarioTrailer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';
	local tmpStr = 'setLiftAxle="'..tostring(self.setLiftAxleUp)..'" ';
	attributes = attributes .. tmpStr;
	tmpStr = 'axleCyls.value="'..tostring(self.axleCyls.value)..'" ';
	attributes = attributes .. tmpStr;
	return attributes, nil;
end;

function VarioTrailer:readStream(streamId, connection)
	local setLiftAxle = streamReadBool(streamId);
	self:setLiftAxle(setLiftAxle, true);
	local axlesOffset = streamReadFloat32(streamId);
	self:setAxlesOffset(axlesOffset, true);
end;

function VarioTrailer:writeStream(streamId, connection)
	streamWriteBool(streamId, self.setLiftAxleUp);
	streamWriteFloat32(streamId, self.axleCyls.value);
end;

function VarioTrailer:mouseEvent(posX, posY, isDown, isUp, button)

end;

function VarioTrailer:keyEvent(unicode, sym, modifier, isDown)

end;

function VarioTrailer:update(dt)
	
	
	_=[[ if self.firstAttachTime > 0 then
		self.firstAttachTime = self.firstAttachTime-dt;
		if not self.firstAttachOnLoad then
			local attacherJoint = self.attacherJoints[1];
			if attacherJoint ~= nil then
				if attacherJoint.jointIndex == 0 then
					for k, attachable in pairs(g_currentMission.attachables) do
						if attachable.attacherVehicle == nil and attachable.attacherJoint.jointType == attacherJoint.jointType then
							local px, py, pz = getWorldTranslation(attacherJoint.jointTransform);
							local vx, vy, vz = getWorldTranslation(attachable.attacherJoint.node);
							local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
							if distance < 0.6 then
								--self:attachImplement(attachable, 1);
								self.firstAttachOnLoad = true;
								break;
							end;
						end;
					end;
				end;
			end;
		end;
	end; ]]

	
	self:setTowballDirection();

	if self.updateSteeringAxleAngle then
		if self.attacherVehicle ~= nil and self.movingDirection < 0 then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 + (self.lastSpeed*-3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;
		end;
	end;
	
	if self:getIsActiveForInput() then
		local moveAxles = false;
		local offset = 0;
		if InputBinding.isPressed(InputBinding.VARIOTRAILER_raiseAxles) then
			offset = Utils.getMovedLimitedValues({self.axleCyls.value}, {self.axleCyls.start}, {self.axleCyls.fin}, 1, self.axleCyls.duration, dt, false);
			moveAxles = true;
		elseif InputBinding.isPressed(InputBinding.VARIOTRAILER_lowerAxles) then
			offset = Utils.getMovedLimitedValues({self.axleCyls.value}, {self.axleCyls.start}, {self.axleCyls.fin}, 1, self.axleCyls.duration, dt, true);
			moveAxles = true;
		end;
		
		if moveAxles then
			self:setAxlesOffset(offset[1]);
		end;
		self.moveAxles = moveAxles;

		if InputBinding.hasEvent(InputBinding.VARIOTRAILER_liftAxle) then
			self:setLiftAxle(not self.setLiftAxleUp);
		end;
	end;	-- ?already
	
		local disable = false;
		if self.attachedImplements[1] ~= nil then
			if self.attachedImplements[1].object ~= nil then
				if self.attachedImplements[1].object.fillLevel > 0 then
					--disable = true
				end;
			end;
		end;
		if self.axleCyls.value > self.axleCyls.start then
			disable = true;
		end;		
		local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 5;	
		if toFast then
			disable = true;
		end;

		if disable then
			self.selectedImplement = 0;
			self.closedAttacher = true;
		_=[[
			if table.getn(self.attachedImplements) == 0 then
				self.attacherBackUp = self.attacherJoints[1];
				self.attacherJoints[1] = nil;
			else
				self.attacherBackUp = self.attacherJoints[1];
				--for i,j in pairs
			end;
		else
			self.selectedImplement = table.getn(self.attachedImplements);
			if self.attacherJointBackup ~= nil then
				self.attacherJoints[1] = self.attacherJointBackup;
				self.attacherBackUp = nil; 
			end;
		end; ]]
		else
			self.selectedImplement = table.getn(self.attachedImplements);
			self.closedAttacher = false;
		end;

	--end;

	if self.attachedImplements[1] ~= nil then
		if self.attachedImplements[1].object ~= nil then
			if ( self.attachedImplements[1].object.fillLevel / self.attachedImplements[1].object.capacity ) > 0.25 then
				self.setLiftAxleUp = false;
			end;
		end;
	end;
	
	local moveLiftAxle = false;
	if not self.moveAxles then
		if self.setLiftAxleUp and self.liftAxleIsUp == false then
			moveLiftAxle = true;
		elseif self.setLiftAxleUp == false and self.liftAxleIsDown == false then
			moveLiftAxle = true;
		end;
	end;
	
	--if moveLiftAxle == true then
	if true then
		local x, y, z = getTranslation( self.axleCyls.cyls[1].node );
		local duration = 2500 * ( 1 - math.abs(self.axleCyls.value - self.axleCyls.start) / math.abs(self.axleCyls.finLift - self.axleCyls.start) );
		local offset = Utils.getMovedLimitedValues({y}, {math.max(self.axleCyls.start, self.axleCyls.value)}, {self.axleCyls.finLift}, 1, duration, dt, self.setLiftAxleUp);
		for i,j in pairs(self.axleCyls.cyls) do
			if i > 2 or j.node == nil then 
				break;
			end;
			local x, y, z = getTranslation( j.node );
			setTranslation(j.node, x, math.max(self.axleCyls.start, math.min(self.axleCyls.finLift, offset[1])), z);
			if self.isServer then				
				setJointFrame(self.componentJoints[j.joint].jointIndex, 0, self.componentJoints[j.joint].jointNode);
			end;
		end;
		self.liftAxleValue = offset[1];
		self.liftAxleIsUp = false;
		self.liftAxleIsDown = false;
		if offset[1] == self.axleCyls.finLift then
			self.liftAxleIsUp = true;
		end;
		if offset[1] == self.axleCyls.start then --math.max(self.axleCyls.start, self.axleCyls.value) then
			self.liftAxleIsDown = true;
		end;
	end;		
	
end;

function VarioTrailer:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 0, 1);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;
	
	local steeringAxleAngle = 0;
	if self.attacherVehicle ~= nil then
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		steeringAxleAngle = -angle*0.6;
	end;
	setRotation(self.towBallAngle, 0, steeringAxleAngle, 0);

	
end;

function VarioTrailer:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function VarioTrailer:setTowballDirection()
	if self.leftFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftCylinder);
		local bx, by, bz = getWorldTranslation(self.leftFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.leftCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.leftCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.leftDistance ~= nil then
			setTranslation(self.attacherCylinder.leftPunch, 0, 0, distance-self.attacherCylinder.leftDistance);
		end;
	end;
	if self.rightFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightCylinder);
		local bx, by, bz = getWorldTranslation(self.rightFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.rightCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.rightCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.rightDistance ~= nil then
			setTranslation(self.attacherCylinder.rightPunch, 0, 0, distance-self.attacherCylinder.rightDistance);
		end;
	end;
end;

function VarioTrailer:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function VarioTrailer:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function VarioTrailer:draw()
	g_currentMission:addHelpButtonText( g_i18n:getText("VARIOTRAILER_liftAxle"), InputBinding.VARIOTRAILER_liftAxle);
	g_currentMission:addExtraPrintText( string.format(""..g_i18n:getText("VARIOTRAILER_raiseLowerAxles").."", 
									InputBinding.getKeyNamesOfDigitalAction(InputBinding.VARIOTRAILER_raiseAxles),
									InputBinding.getKeyNamesOfDigitalAction(InputBinding.VARIOTRAILER_lowerAxles) ) );
	
	if self.closedAttacher == true then
		g_currentMission:addExtraPrintText( g_i18n:getText("VARIOTRAILER_lockBergVar")  );
		if self.attachedImplements[1] ~= nil then
			if self.attachedImplements[1].object ~= nil then
				self.attachedImplements[1].object:draw();
			end;
		end;
	else
		g_currentMission:addExtraPrintText( g_i18n:getText("VARIOTRAILER_openBergVar")  );
	end;
end;

function VarioTrailer:setAxlesOffset(value, noEventSend)
	SetAxlesOffsetEvent.sendEvent(self, value, noEventSend)
	
	for i,j in pairs(self.axleCyls.cyls) do
		if i > 2 then
			local x, y, z = getTranslation(j.node);
			setTranslation(j.node, x, value, z);
			if self.isServer then
				setJointFrame(self.componentJoints[j.joint].jointIndex, 0, self.componentJoints[j.joint].jointNode);
			end;
			self.axleCyls.value = value;
			
			if self.setLifAxleUp == false then
				self.liftAxleValue = value;
			end;
			
			--
			local prct = (value-self.axleCyls.start)/(self.axleCyls.fin-self.axleCyls.start);
			local newRot = Utils.degToRad(-0.74883+((-3.48815+0.74883))*prct);
			setRotation(self.componentJoints[1].jointNode, newRot, 0, 0);
			if self.isServer then
				setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);
				
				if self.attacherVehicle ~= nil then
					local attacherVehicle = self.attacherVehicle;
					while true do
						if attacherVehicle.attacherVehicle ~= nil then
							attacherVehicle = attacherVehicle.attacherVehicle;
							if SpecializationUtil.hasSpecialization(Steerable, attacherVehicle.specializations) then
								break;
							end;
						else
							break;
						end;
					end;
					if attacherVehicle ~= nil then
						for k, implement in pairs(attacherVehicle.attachedImplements) do
							local jointDesc = attacherVehicle.attacherJoints[implement.jointDescIndex];
							if implement.object == self then
								setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	local prct = (value-self.axleCyls.start)/(self.axleCyls.fin-self.axleCyls.start);
	local springRot = prct * (self.axleSpringsRotMax-self.axleSpringsRotMin);
	for i,j in pairs(self.axleSprings) do
		setRotation(j.node, springRot, 0, 0);
	end;
	
end;

function VarioTrailer:setLiftAxle(value, noEventSend)
	SetLiftaxleEvent.sendEvent(self, value, noEventSend);
	self.setLiftAxleUp = value;
end

--
--
--
--
--
--
SetAxlesOffsetEvent = {};
SetAxlesOffsetEvent_mt = Class(SetAxlesOffsetEvent, Event);

InitEventClass(SetAxlesOffsetEvent, "SetAxlesOffsetEvent");

function SetAxlesOffsetEvent:emptyNew()
    local self = Event:new(SetAxlesOffsetEvent_mt);
    self.className = "SetAxlesOffsetEvent";
    return self;
end;

function SetAxlesOffsetEvent:new(object, value)
    local self = SetAxlesOffsetEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function SetAxlesOffsetEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.value = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetAxlesOffsetEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.value);
end;

function SetAxlesOffsetEvent:run(connection)
	self.object:setAxlesOffset(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetAxlesOffsetEvent:new(self.object, self.value), nil, connection, self.object);
	end;
end;

function SetAxlesOffsetEvent.sendEvent(vehicle, value, noEventSend)

	if vehicle.axleCyls.value ~= value then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetAxlesOffsetEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetAxlesOffsetEvent:new(vehicle, value));
			end;
		end;
	end;
end;


--
--
--
--
--
--
SetLiftaxleEvent = {};
SetLiftaxleEvent_mt = Class(SetLiftaxleEvent, Event);

InitEventClass(SetLiftaxleEvent, "SetLiftaxleEvent");

function SetLiftaxleEvent:emptyNew()
    local self = Event:new(SetLiftaxleEvent_mt);
    self.className = "SetLiftaxleEvent";
    return self;
end;

function SetLiftaxleEvent:new(object, value)
    local self = SetLiftaxleEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function SetLiftaxleEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.value = streamReadBool(streamId);
    self:run(connection);
end;

function SetLiftaxleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.value);
end;

function SetLiftaxleEvent:run(connection)
	self.object:setLiftAxle(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetLiftaxleEvent:new(self.object, self.value), nil, connection, self.object);
	end;
end;

function SetLiftaxleEvent.sendEvent(vehicle, value, noEventSend)

	if vehicle.setLiftAxleUp ~= value then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetLiftaxleEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetLiftaxleEvent:new(vehicle, value));
			end;
		end;
	end;
end;



