VarioStreuer = {};

function VarioStreuer.prerequisitesPresent(specializations)
	return true;
end;

function VarioStreuer:load(xmlFile)
	self.setWork = SpecializationUtil.callSpecializationsFunction("setWork");
	self.setGate = SpecializationUtil.callSpecializationsFunction("setGate");
	self.transformFillPlane = SpecializationUtil.callSpecializationsFunction("transformFillPlane");
	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, VarioStreuer.setFillLevel);
	self.lastFillDelta = 0;
	
	self.origCuttingArea = self.cuttingAreas[1];
	self.setWorkSmall = true;
	self.isWorkSmall = true;
	self.isWorkLarge = false;
	self.work = {};
	self.work.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work#node"));
	self.work.startTrans = Utils.getVectorNFromString(getXMLString(xmlFile,"vehicle.work#startTrans"));
	self.work.endTrans = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.work#endTrans"));
	self.work.startRot = Utils.getVectorNFromString(getXMLString(xmlFile,"vehicle.work#startRot"));
	self.work.endRot = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.work#endRot"));
	self.work.duration = getXMLInt(xmlFile, "vehicle.work#duration");
	for i=1,3 do
		self.work.startRot[i] = Utils.degToRad(self.work.startRot[i]);
		self.work.endRot[i] = Utils.degToRad(self.work.endRot[i]);
	end;
	self.work.cuttingAreaSmall = {};
	self.work.cuttingAreaSmall.start = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work.cuttingAreaSmall#startIndex"));
	self.work.cuttingAreaSmall.width = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work.cuttingAreaSmall#widthIndex"));
	self.work.cuttingAreaSmall.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work.cuttingAreaSmall#heightIndex"));
	self.work.cuttingAreaSmall.foldMinLimit = 0;
	self.work.cuttingAreaSmall.foldMaxLimit = 1;
	self.work.cuttingAreaNormal = {};
	self.work.cuttingAreaNormal.start = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreas.cuttingArea1#startIndex"));
	self.work.cuttingAreaNormal.width = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreas.cuttingArea1#widthIndex"));
	self.work.cuttingAreaNormal.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreas.cuttingArea1#heightIndex"));	
	self.work.cuttingAreaNormal.foldMinLimit = 0;
	self.work.cuttingAreaNormal.foldMaxLimit = 1;
	self.cuttingAreas[1] = self.work.cuttingAreaSmall;
	
	self.work.origPS = {};
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work.particleSystem#index"));
	self.work.origPS.particleSystems = {};
	self.work.origPS.node = node;
	self.work.origPS.state = false;
	Utils.loadParticleSystem(xmlFile, self.work.origPS.particleSystems, "vehicle.work.particleSystem", node, false, nil, self.baseDirectory);
	self.work.smallPS = {};
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.work.particleSystemSmall#index"));
	self.work.smallPS.particleSystems = {};
	self.work.smallPS.node = node;
	self.work.smallPS.state = false;
	Utils.loadParticleSystem(xmlFile, self.work.smallPS.particleSystems, "vehicle.work.particleSystemSmall", node, false, nil, self.baseDirectory);
	
	self.setGateOpen = false;
	self.gateIsOpen = false;
	self.gateIsClose = true;
	
	self.ruload = {};
	self.ruload.endIdx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.unloading#endIdx"));
	local x, y, z = getTranslation(self.ruload.endIdx);
	self.ruload.planeStartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillPlanes.fillPlane(0).node(0)#index"));
	local x2, y2, z2 = getTranslation(self.ruload.planeStartNode);
	self.ruload.planeStartPos = {x2, y2, z2};
	self.ruload.dist = z - z2;
	
	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#unloadingSpeed"), 0.001);
	self.hayBase.loadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#loadingSpeed"), 0.0005);
	self.hayBase.speed = self.hayBase.loadingSpeed;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);		

end;

function VarioStreuer:delete()
end;

function VarioStreuer:readStream(streamId, connection)

end;

function VarioStreuer:writeStream(streamId, connection)

end;

function VarioStreuer:mouseEvent(posX, posY, isDown, isUp, button)

end;

function VarioStreuer:keyEvent(unicode, sym, modifier, isDown)

end;

function VarioStreuer:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.CASTER_switchWork) then
			self:setWork(not self.setWorkSmall);
		end;
		if InputBinding.hasEvent(InputBinding.CASTER_switchGate) then
			if self.gateIsOpen and self.isTurnedOn then
				self:setIsTurnedOn(not self.isTurnedOn);
			end;
			self:setGate(not self.setGateOpen);
		end;
	end;
	
end;

function VarioStreuer:updateTick(dt)
	if (self.setWorkSmall == true and self.isWorkSmall == false) or
		(self.setWorkSmall == false and self.isWorkLarge == false) then
		self.isWorkSmall = false;
		self.isWorkLarge = false;
		
		local tx,ty,tz = getTranslation(self.work.node);
		local nt = Utils.getMovedLimitedValues({tx, ty, tz}, self.work.startTrans, self.work.endTrans, 3, self.work.duration, dt, not self.setWorkSmall);
		setTranslation(self.work.node, nt[1], nt[2], nt[3]);
		
		local rx,ry,rz = getRotation(self.work.node);
		local nr = Utils.getMovedLimitedValues({rx, ry, rz}, self.work.startRot, self.work.endRot, 3, self.work.duration, dt, not self.setWorkSmall);
		setRotation(self.work.node, nr[1], nr[2], nr[3]);
		
		for k, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
		
		local prct = (rx-self.work.startRot[1])/(self.work.endRot[1]-self.work.startRot[1]);
		setRotation(self.work.smallPS.node, Utils.degToRad(prct*45), 0, 0);
		--setRotation(self.work.origPS.node, Utils.degToRad(prct*45), 0, 0);
		
		local same = true;
		for i=1,3 do
			if nt[i] ~= self.work.startTrans[i] or nr[i] ~= self.work.startRot[i] then
				same = false;
				break;
			end;
		end;
		local isStart = same;
		local isWork = false;
		if not isStart then
			same = true;
			for i=1,3 do
				if nt[i] ~= self.work.endTrans[i] or nr[i] ~= self.work.endRot[i] then
					same = false;
					break;
				end;
			end;
			isWork = same;
		end;
		if isStart then 
			self.cuttingAreas[1] = self.work.cuttingAreaSmall;
			self.isWorkSmall = true;
			--self.sprayValves[1].particleSystems = self.work.smallPS.particleSystems;
		end;
		if isWork then
			self.cuttingAreas[1] = self.work.cuttingAreaNormal;
			self.isWorkLarge = true;
			--self.sprayValves[1].particleSystems = self.work.origPS.particleSystems;
		end;
		--print(" "..tostring(self.setWorkSmall).." "..tostring(self.isWorkSmall).." "..tostring(self.isWorkLarge).." "..tostring(rx).." "..tostring(self.work.startRot[3]).." "..tostring(self.work.endRot[3]));
	end;
	
	if self.isTurnedOn and self.isWorkSmall then
		Utils.setEmittingState(self.sprayValves[1].particleSystems, false);
		if self.work.origPS.state ~= false then
			Utils.setEmittingState(self.work.origPS.particleSystems, false);
			self.work.origPS.state = false;
		end;
		if self.work.smallPS.state ~= true then
			Utils.setEmittingState(self.work.smallPS.particleSystems, true);
			self.work.smallPS.state = true;
		end;
	else
		if self.isTurnedOn then
			Utils.setEmittingState(self.sprayValves[1].particleSystems, false);
			if self.work.origPS.state ~= true then
				Utils.setEmittingState(self.work.origPS.particleSystems, true);
				self.work.origPS.state = true;
			end;
		else
			if self.work.origPS.state ~= false then
				Utils.setEmittingState(self.work.origPS.particleSystems, false);
				self.work.origPS.state = false;
			end;
		end;		
		if self.work.smallPS.state ~= false then
			Utils.setEmittingState(self.work.smallPS.particleSystems, false);
			self.work.smallPS.state = false;
		end;
	end;
	

	
	-- schieber
	if (self.setGateOpen == true and self.gateIsOpen == false) or
		(self.setGateOpen == false and self.gateIsClose == false) then
		self.gateIsOpen = false;
		self.gateIsClose = false;	
		
		if self.setGateOpen or self.isTurnedOn then
			setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
		else
			setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
		end;	
		
		local speedScale;
		if self.setGateOpen then
			speedScale = 1.0;
		else
			speedScale = -1.0;
		end;
		
		local curTime = self:getAnimationTime('openDoor');
		self:playAnimation('openDoor', speedScale, curTime); 

		local doneMov = false;
		if self.fillLevel ~= 0 and self.setGateOpen then
			local fillTypeName = Fillable.fillTypeIntToName[self.currentFillType];
			local fillPlane = self.fillPlanes[fillTypeName];		
			local tx, ty, tz = getTranslation(fillPlane.nodes[1].node);
			local curDist = tz - self.ruload.planeStartPos[3];
			local t = self.fillLevel/self.capacity;
			local goal = (1.0 - t) * self.ruload.dist;
			local newDist = {0};
			if goal ~= 0 then
				newDist = Utils.getMovedLimitedValues({curDist}, {0}, {goal}, 1, 5000*(1.0 - t), dt, self.setGateOpen);
				setTranslation(fillPlane.nodes[1].node, tx, ty, self.ruload.planeStartPos[3]+newDist[1]);
			end;			
			--local x,y,z, rx,ry,rz, sx,sy,sz = fillPlane.nodes[1].animCurve:get(t);
			local sx, sy, sz = getScale(fillPlane.nodes[1].node);
			setScale(fillPlane.nodes[1].node, sx, math.min(1.0, t+math.abs(newDist[1]/self.ruload.dist)), 1.0-(newDist[1]/self.ruload.dist)); 
			if (newDist[1] == 0 and not self.setGateOpen) or 
				(self.setGateOpen and (newDist[1] == goal or (t == 1 and newDist[1] == 0)) ) then
				doneMov = true;
			end;
			--print(tostring(fillPlane.nodes[1].node).." "..tostring(curDist).." "..tostring(newDist[1]).." "..tostring(goal).." "..tostring(self.ruload.dist).." "..tostring(self.setGateOpen));
		else
			doneMov = true;
		end;
		
		if curTime == 0 and doneMov then
			self.gateIsClose = true
		end;
		if curTime == 1 and doneMov then 
			self.gateIsOpen = true;
		end;
		
	end;
	
	if self.isTurnedOn and not self.gateIsOpen then
		self:setIsTurnedOn(false);
	end;
		
	
end;

function VarioStreuer:onAttach(attacherVehicle)

end;

function VarioStreuer:onDetach()

end;

function VarioStreuer:onStartTip(currentTipTrigger, noEventSend)
end;

function VarioStreuer:onEndTip(noEventSend)
end;

function VarioStreuer:draw()
	g_currentMission:addHelpButtonText( g_i18n:getText("CASTER_work"), InputBinding.CASTER_switchWork );
	g_currentMission:addHelpButtonText( g_i18n:getText("CASTER_gate"), InputBinding.CASTER_switchGate );
end;

function VarioStreuer:setWork(value, noEventSend)
	SetWorkEvent.sendEvent(self, value, noEventSend);
	self.setWorkSmall = value;
end;

function VarioStreuer:setGate(value, noEventSend)
	SetGateEvent.sendEvent(self, value, noEventSend);
	self.setGateOpen = value;
end;

function VarioStreuer:transformFillPlane()
	local t = self.fillLevel/self.capacity;
	
end;

function VarioStreuer:setFillLevel(func, fillLevel, fillType, force)
	if (force == nil or force == false) and not self:allowFillType(fillType, false) then
        return
    end;
	self.lastFillDelta = fillLevel - self.fillLevel;
    self.currentFillType = fillType;
    self.fillLevel = fillLevel;
	if self.fillLevel > self.capacity then
		self.fillLevel = self.capacity;
	end;
	if self.fillLevel < 0 then
		self.fillLevel = 0;
		self.currentFillType = Fillable.FILLTYPE_UNKNOWN;
	end;

   
	if self.isClient then
		if self.currentFillPlane ~= nil then
			for _, node in ipairs(self.currentFillPlane.nodes) do
				setVisibility(node.node, false);
			end;
			self.currentFillPlane = nil;
		end;
		if self.fillPlanes ~= nil and self.defaultFillPlane ~= nil and fillType ~= Fillable.FILLTYPE_UNKNOWN then
			local fillTypeName = Fillable.fillTypeIntToName[fillType];
			local fillPlane = self.fillPlanes[fillTypeName];
			if fillPlane == nil then
				fillPlane = self.defaultFillPlane;
			end;
			local t = self.fillLevel/self.capacity;
			if self.lastFillDelta > 0 then
				for _, node in ipairs(fillPlane.nodes) do
					local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
		 
					setTranslation(node.node, x, y, z);
					setRotation(node.node, rx, ry, rz);
					setScale(node.node, sx, sy, sz);
					setVisibility(node.node, self.fillLevel > 0);
				end;
			else
				for _, node in ipairs(fillPlane.nodes) do
					local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
		 
					setTranslation(node.node, x, y, self.ruload.planeStartPos[3]+self.ruload.dist*(1.0 - t));
					setRotation(node.node, rx, ry, rz);
					setScale(node.node, sx, 1, t);
					setVisibility(node.node, self.fillLevel > 0);
				end;			
			end;
			self.currentFillPlane = fillPlane;
		end;
	end;
end;


--
--
--
--
--
SetWorkEvent = {};
SetWorkEvent_mt = Class(SetWorkEvent, Event);

InitEventClass(SetWorkEvent, "SetWorkEvent");

function SetWorkEvent:emptyNew()
    local self = Event:new(SetWorkEvent_mt);
    self.className = "SetWorkEvent";
    return self;
end;

function SetWorkEvent:new(object, value)
    local self = SetWorkEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function SetWorkEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.value = streamReadBool(streamId);
    self:run(connection);
end;

function SetWorkEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.value);
end;

function SetWorkEvent:run(connection)
	self.object:setWork(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWorkEvent:new(self.object, self.value), nil, connection, self.object);
	end;
end;

function SetWorkEvent.sendEvent(vehicle, value, noEventSend)

	if vehicle.setWorkSmall ~= value then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetWorkEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetWorkEvent:new(vehicle, value));
			end;
		end;
	end;
end;

 
--
--
--
--
--
SetGateEvent = {};
SetGateEvent_mt = Class(SetGateEvent, Event);

InitEventClass(SetGateEvent, "SetGateEvent");

function SetGateEvent:emptyNew()
    local self = Event:new(SetGateEvent_mt);
    self.className = "SetGateEvent";
    return self;
end;

function SetGateEvent:new(object, value)
    local self = SetGateEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function SetGateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.value = streamReadBool(streamId);
    self:run(connection);
end;

function SetGateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.value);
end;

function SetGateEvent:run(connection)
	self.object:setGate(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetGateEvent:new(self.object, self.value), nil, connection, self.object);
	end;
end;

function SetGateEvent.sendEvent(vehicle, value, noEventSend)

	if vehicle.setGateOpen ~= value then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetGateEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetGateEvent:new(vehicle, value));
			end;
		end;
	end;
end;