--
-- Sowing Machine Update
-- 
-- blocks seedChanging
-- @author  Geri-G
-- @date  14/11/10

local orginalUpdateTick = SowingMachine.updateTick;
local orginalLoad = SowingMachine.load;

SowingMachine.load = function(self, xmlFile)
	orginalLoad(self, xmlFile);
	self.allowsSeedChanging = true;
end;
SowingMachine.updateTick = function(self, dt)
	
	orginalUpdateTick(self, dt);
	
	if self:getIsActive() then
		if self.fillLevel > 0 then
		
			if self.fillLevel >= self.capacity and self.wasActivated then
				if self.attacherVehicle ~= nil then
					if self.attacherVehicle.startAITractor~= nil then
						self.attacherVehicle:startAITractor();
					elseif self.attacherVehicle.startAIThreshing~= nil then
						self.attacherVehicle:startAIThreshing();
					end;
				end;
			end;
			self.wasActivated = nil;
			--self:setSeedChanging(false);

		elseif self.fillLevel <=0 then
			--self:setSeedChanging(true);
			if self.attacherVehicle ~= nil then
				if self.attacherVehicle.stopAITractor~= nil then
					self.attacherVehicle:stopAITractor();
					self.wasActivated = true;
				elseif self.attacherVehicle.stopAIThreshing~= nil then
					self.attacherVehicle:stopAIThreshing();
					self.wasActivated = true;
				end;
			end;
		end;

		if self.lastSowingArea >0 then
			local useFillLevel = true;
			if self.capacity == 0 or self:getIsHired() then
				useFillLevel = false;
			end;

			if not useFillLevel then
				local fruitDesc = FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed] ];
				local usage = fruitDesc.seedUsagePerSqm*self.lastSowingArea;
				
				self:setFillLevel(self.fillLevel - usage, self.currentFillType);

				local delta = usage*g_seedsPricePerLiter;
				g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal - delta;
				g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession - delta;

				g_currentMission:addSharedMoney(delta);
			end;
		end;
	end;
end;
