-- Claas kasza
-- powered by hz888
-- modification xyzspain
Macdond50 = {};

function Macdond50.prerequisitesPresent(specializations)
    return true;
end;

function Macdond50:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

    local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if threshingSound ~= nil and threshingSound ~= "" then
        threshingSound = Utils.getFilename(threshingSound, self.baseDirectory); 
        self.threshingSound = createSample("threshingSound");
        self.threshingSoundEnabled = false;
        loadSample(self.threshingSound, threshingSound, false);
        self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
        self.threshingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#volume"), 1);
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;

    local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    self.isTurnedOn = false;
    self.wasToFast = false;
  self.reel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));
  self.reelSpike1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpike1#index"));
   self.reelSpike2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpike2#index"));
    self.reelSpike3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpike3#index"));
	 self.reelSpike4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpike4#index"));
	  self.reelSpike5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpike5#index"));
     ---rotaciones y reanslaciones
	 local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	self.rotation1max=false;
	
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
     
    end;
	self.rotation2max=false;
	
	 local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
     
    end;
	self.rotation3max=false;
	
	 	-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	
		---emision de particulas ruedas

self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
	
end;

function Macdond50:delete()

    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;

end;

function Macdond50:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Macdond50:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_h   then
	self.isTurnedOn = not self.isTurnedOn;
		end;
		
	
	
end;

function Macdond50:update(dt)
local dens = 0; local dens1; local dens2; local dens3;
	 local x,y,z = getWorldTranslation(self.wheels[1].repr);
	 local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
	 local x2,y2,z2 = getWorldTranslation(self.wheels[2].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		
		
		for k=1, 2 do
			Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
		end;
	
	end;
    self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;

    if self:getIsActive() then
	
   

-------------
  if self.isTurnedOn then
            local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
            if not toFast then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                    local foldAnimTime = self.foldAnimTime;
                    local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                        end;
                    end;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[i];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
                                    end;
                                end;
                            else
                                sum = sum + area;
                            end;
                        end;
                    end;
                    if sum > 0 and numDropAreas > 0 then
                        local dropArea = self.windrowerDropAreas[1];
                        local x,y,z = getWorldTranslation(dropArea.start);
                        local x1,y1,z1 = getWorldTranslation(dropArea.width);
                        local x2,y2,z2 = getWorldTranslation(dropArea.height);
                        local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                        sum = sum + old;
                        local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
                        if value >= 1 then
                            value = math.min(value, g_currentMission.maxWindrowValue);
                            Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
                        end;
                    end;
                end;
            end;

            if not self.threshingSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.threshingSound, self.threshingSoundPitchOffset);
                playSample(self.threshingSound, 0, self.threshingSoundVolume, 0);
                self.threshingSoundEnabled = true;
            end;

            self.wasToFast = toFast;

        else
            if self.threshingSoundEnabled then
                stopSample(self.threshingSound);
                self.threshingSoundEnabled = false;
            end;
        end;--turnedon
		 if self.isTurnedOn and self.reel ~= nil then
		rotate(self.reel, -dt*0.004, 0, 0);
    end;
		 if self.isTurnedOn and self.reelSpike1 ~= nil then
		rotate(self.reelSpike1, dt*0.004, 0, 0);
    end;
		 if self.isTurnedOn and self.reelSpike2 ~= nil then
		rotate(self.reelSpike2, dt*0.004, 0, 0);
    end;
		 if self.isTurnedOn and self.reelSpike3 ~= nil then
		rotate(self.reelSpike3, dt*0.004, 0, 0);
    end;
		 if self.isTurnedOn and self.reelSpike4 ~= nil then
		rotate(self.reelSpike4, dt*0.004, 0, 0);
    end;
		 if self.isTurnedOn and self.reelSpike5 ~= nil then
		rotate(self.reelSpike5, dt*0.004, 0, 0);
    end;
	
        self.wasToFast = toFast;
	---rotacion brazos en arranque
	 if self.isTurnedOn then
	 self.rotation1max=true;
	  self.rotation2max=true;
	   self.rotation3max=true;
	 else
	  self.rotation1max=false;
	  self.rotation2max=false;
	self.rotation3max=false;	  
	  end;
	-----------	
    end; --- active
	
	
	
	if self.rotation1 ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	if self.rotation2 ~= nil  then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.rotation3 ~= nil  then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		 local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		
self:setHydraulicDirection();	
end;

function Macdond50:draw()

    if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.ACTIVATE_THRESHING);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.ACTIVATE_THRESHING);
    end;

    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;

end;
function Macdond50:onAttach()



end;
function Macdond50:onDetach()

    if self.deactivateOnDetach then
        Macdond50.onDeactivate(self);
    else
        Macdond50.onDeactivateSounds(self)
    end;

end;

function Macdond50:onLeave()

    if self.deactivateOnLeave then
        Macdond50.onDeactivate(self);
    else
        Macdond50.onDeactivateSounds(self)
    end;

end;

function Macdond50:onDeactivate()

    Macdond50.onDeactivateSounds(self)
    self.isTurnedOn = false;

end;

function Macdond50:onDeactivateSounds()

    if self.threshingSoundEnabled then
        stopSample(self.threshingSound);
        self.threshingSoundEnabled = false;
    end;

end;
function Macdond50:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;