print("loading Clock-MOD");

modClassEventListener = {};

function modClassEventListener:loadMap(name)
	self.startzeit = os.time();
	local path = getUserProfileAppPath()
	local path = path.."mods/clock/"
	local file = path.."clock.xml"
	xmlid = loadXMLFile("xmldatei", file);
	self.language = getXMLString(xmlid, "clock.language#lang");
	self.counter = getXMLString(xmlid, "clock.counter#active");
	self.timform = getXMLInt(xmlid, "clock.time#format");
	self.analog = getXMLString(xmlid, "clock.analog#active");
	
	self.months = {};
    self.months[01] = "Jan";
    self.months[02] = "Feb";
    self.months[03] = "Mr";
    self.months[04] = "Apr";
    self.months[05] = "Mai";
    self.months[06] = "Jun";
    self.months[07] = "Jul";
    self.months[08] = "Aug";
    self.months[09] = "Sep";
    self.months[10] = "Okt";
    self.months[11] = "Nov";
    self.months[12] = "Dez";

	self.days = {};
	self.days[1] = "Sonntag";
	self.days[2] = "Montag";
	self.days[3] = "Dienstag";
	self.days[4] = "Mittwoch";
	self.days[5] = "Donnerstag";
	self.days[6] = "Freitag";
	self.days[7] = "Samstag";
	
	self.de_tag = self.days[tonumber(os.date("%w"))+1];
	self.curmon = os.date("%m")
	self.de_monat = self.months[tonumber(self.curmon)];
	
end;

function modClassEventListener:deleteMap()

end;

function modClassEventListener:mouseEvent(posX, posY, isDown, isUp, button)

end;

function modClassEventListener:keyEvent(unicode, sym, modifier, isDown)

end;

function modClassEventListener:update(dt)
		
end;

function modClassEventListener:draw()
	-- Datum anzeigen / Show Date
	if self.language == "en" then
		renderText(0.83, 0.982, 0.02, os.date("%a, %d.%b %Y"));	-- en
	elseif self.language == "de" then
		renderText(0.83, 0.982, 0.02, (self.de_tag..", "..os.date("%d").."."..self.de_monat.." "..os.date("%Y"))); -- de
	else
		renderText(0.83, 0.982, 0.02, os.date("%a, %d.%b %Y")); -- other
	end
	-- Uhrzeit anzeigen / Show Time
	if self.timform == 12 then
	setTextColor(0,1,0,1);
		renderText(0.83, 0.91, 0.015, os.date("%I:%M:%S ")..string.lower(os.date("%p")));	-- 12h
	elseif self.timform == 24 then
	    setTextColor(0,1,0,1);
		renderText(0.83, 0.91, 0.015, os.date("%H:%M:%S"));		-- 24h
	else
		renderText(0.83, 0.91, 0.015, os.date("%I:%M:%S ")..string.lower(os.date("%p")));	-- 12h
	    setTextColor(0, 0, 0, 1.0);	
	end
	
	-- Spielzeit zeigen / Show Playtime
	if self.counter then
		if self.language == "en" then
			renderText(0.83, 0.968, 0.02, " all Playtime:");	-- en
			renderText(0.83, 0.948, 0.02, " Played today:");	-- en
		elseif self.language == "de" then
			renderText(0.83, 0.962, 0.013, "Spielzeit ges.:"); -- de
			renderText(0.83, 0.952, 0.013, "Spielzeit heute:"); -- de
		else
			renderText(0.83, 0.968, 0.01, " all Playtime:"); -- other
			renderText(0.83, 0.948, 0.01, " Played today:");
		end
		self.playhours = math.floor(g_currentMission.missionStats.playTime /60)
		self.playmins = g_currentMission.missionStats.playTime - (self.playhours * 60)
		if self.playmins >= 10 then
			renderText(0.91, 0.962, 0.013, (string.format("%.0f", self.playhours)..":"..string.format("%.0f", self.playmins)));
		else
			renderText(0.91, 0.962, 0.013, (string.format("%.0f", self.playhours)..":0"..string.format("%.0f", self.playmins)));
		end

		self.difftim = os.difftime(os.time(), self.startzeit)
		if self.difftim >= 3600 then
			renderText(0.91, 0.952, 0.013, os.date("%H:%M", (os.difftime(os.time(), self.startzeit))));
		elseif self.difftim >= 60 then
			renderText(0.91, 0.952, 0.013, os.date("0:%M", (os.difftime(os.time(), self.startzeit))));
		else
			renderText(0.91, 0.952, 0.013, os.date("0:00"));
		end
	end;
end;

addModEventListener(modClassEventListener);