extraWeightsEvent = {};
extraWeightsEvent_mt = Class(extraWeightsEvent, Event);

InitEventClass(extraWeightsEvent, "extraWeightsEvent");

function extraWeightsEvent:emptyNew()
    local self = Event:new(extraWeightsEvent_mt);
    self.className="extraWeightsEvent";
    return self;
end;

function extraWeightsEvent:new(vehicle, isVisible)
    local self = extraWeightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.isVisible = isVisible;
    return self;
end;

function extraWeightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isVisible = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function extraWeightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isVisible);
end;

function extraWeightsEvent:run(connection)
	self.vehicle:setIsextraWeightsVisible(self.isVisible, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(extraWeightsEvent:new(self.vehicle, self.isVisible), nil, connection, self.vehicle);
	end;
end;

function extraWeightsEvent.sendEvent(vehicle, isVisible, noEventSend)
	if vehicle.extraWeights.isVisible ~= isVisible then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(extraWeightsEvent:new(vehicle, isVisible), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(extraWeightsEvent:new(vehicle, isVisible));
			end;
		end;
	end;
end;