--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.75, 0.25, 0.02, "");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.75, 0.25, 0.02, "Wcisnij/press Numpad 0: Info");
		renderText(0.66, 0.76, 0.025, "..::Claas MEGA 204 mp ready");			
		renderText(0.66, 0.71, 0.02, "drzwi/door key num 4");
		renderText(0.66, 0.69, 0.02, "zbiornik/tank key num 5");			
		renderText(0.66, 0.67, 0.02, "sieczkarnia/chopper key num 6");
		renderText(0.66, 0.65, 0.02, "swiatla robocze tyl/light work back key num 8");
		renderText(0.66, 0.63, 0.02, "swiatla robocze przod/light work front key num 7");
		renderText(0.66, 0.61, 0.02, "swiatla robocze rura/light work pipe key num 9");
		renderText(0.66, 0.59, 0.02, "kierunkowskaz lewy/blinker left key num 1");
		renderText(0.66, 0.57, 0.02, "kierunkowskaz prawy/blinker prawy key num 3");
		renderText(0.66, 0.55, 0.02, "kierunkowskaz prawy/blinker emerygency key num 2");
		
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




