--
-- self
-- for all self
--
-- @author by landwirtschaftssimulator-2009.de 
-- @Edit & Modernized: Northern_Strike
-- @date  08/06/09
--
-- Copyright (C) 

MTZ_82 = {};

function MTZ_82.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MTZ_82:load(xmlFile)

    self.ventelator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ventelator#index"));

	self.ventelatorSpeed = 0;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.nevid = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nevid1#index"));
    self.nevid1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nevid11#index"));

    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;

	self.SetDoorPanel = SpecializationUtil.callSpecializationsFunction("SetDoorPanel"); 
	self.DoorPanel = true;		      

    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;

    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;

	local rotBrace2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace2#index"));
    if rotBrace2Node ~= nil then
        self.rotBrace2 = {};
        self.rotBrace2.node = rotBrace2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#minRot"));
        self.rotBrace2.minRot = {};
        self.rotBrace2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#maxRot"));
        self.rotBrace2.maxRot = {};
        self.rotBrace2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#rotTime"), 2)*1000;
        self.rotBrace2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#touchRotLimit"), 10));
    end;

    local braceVertNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.braceVert#index"));
    if braceVertNode ~= nil then
        self.braceVert = {};
        self.braceVert.node = braceVertNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#minTrans"));
        self.braceVert.minTrans = {};
        self.braceVert.minTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.minTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#maxTrans"));
        self.braceVert.maxTrans = {};
        self.braceVert.maxTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.maxTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.maxTrans[3] = Utils.getNoNil(z, 0);
        self.braceVert.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#transTime"), 2)*1000;
        self.braceVert.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#touchTransLimit"), 10);
    end;

    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	local doorsoSound = getXMLString(xmlFile, "vehicle.doorsoSound#file");
    if  doorsoSound ~= nil and  doorsoSound ~= "" then
        doorsoSound = Utils.getFilename( doorsoSound, self.baseDirectory); 
        self.doorsoSound = createSample(" doorsoSound");
        self.doorsoSoundPlaying = false;
        loadSample(self. doorsoSound, doorsoSound, false);
        self.doorsoSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorsoSound#volume"),1);
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontlights = {};
    for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;	
   
	
	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	
	 local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
    local rotationPartNodehidra1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra1#index"));
    if rotationPartNodehidra1 ~= nil then
        self.rotationParthidra1 = {};
        self.rotationParthidra1.node = rotationPartNodehidra1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra1#minRot"));
        self.rotationParthidra1.minRot = {};
        self.rotationParthidra1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra1#maxRot"));
        self.rotationParthidra1.maxRot = {};
        self.rotationParthidra1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#rotTime"), 2)*1000;
        self.rotationParthidra1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#touchRotLimit"), 10));
    end;
        local rotationPartNodehidra2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra2#index"));
    if rotationPartNodehidra2 ~= nil then
        self.rotationParthidra2 = {};
        self.rotationParthidra2.node = rotationPartNodehidra2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra2#minRot"));
        self.rotationParthidra2.minRot = {};
        self.rotationParthidra2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra2#maxRot"));
        self.rotationParthidra2.maxRot = {};
        self.rotationParthidra2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#rotTime"), 2)*1000;
        self.rotationParthidra2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#touchRotLimit"), 10));
    end;
      local rotationPartNodehidra3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra3#index"));
    if rotationPartNodehidra3 ~= nil then
        self.rotationParthidra3 = {};
        self.rotationParthidra3.node = rotationPartNodehidra3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra3#minRot"));
        self.rotationParthidra3.minRot = {};
        self.rotationParthidra3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra3#maxRot"));
        self.rotationParthidra3.maxRot = {};
        self.rotationParthidra3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#rotTime"), 2)*1000;
        self.rotationParthidra3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#touchRotLimit"), 10));
    end;
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    hornSoundFile = Utils.getFilename("Sound/horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("HupenSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 400);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1300);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2200);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
	--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("Sound/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("Sound/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	
	self.farlightsActive = false;
    self.frontlightsActive = false;
	self.worklightsActive = false;
    self.hornPlaying = false;
    

end;

function MTZ_82:readStream(streamId, connection)
    self:SetDoorPanel(streamReadBool(streamId), true);
end;

function MTZ_82:writeStream(streamId, connection)
    streamWriteBool(streamId, self.DoorPanel);
end;

function MTZ_82:keyEvent(unicode, sym, modifier, isDown)

	if sym == self.keys.kirohydUp then
		self.armDownMax = isDown;
		self.armUpMax = isDown;
		self.rotBrace2Max = isDown;
		self.braceVertMax = isDown;
		self.armHydrMax = isDown;
	end;
	if sym == self.keys.kirohydDown then
		self.armDownMin = isDown;
		self.armUpMin = isDown;
		self.rotBrace2Min = isDown;
		self.braceVertMin = isDown;
		self.armHydrMin = isDown;
	end;

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;
    if isDown and sym == Input.KEY_7 then
	    self.frontlightsActive = not self.frontlightsActive;
	    self.farlightsActive = false;
		self.worklightsActive = false;
	end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.worklightsActive = false;
	end;
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 
     if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	end; 
	 if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxteto = not self.rotationMaxteto;
	end;
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
        	if isDown and sym == Input.KEY_KP_0 then 
		self.rotationMaxhidra3 = not self.rotationMaxhidra3;
        end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------

end;


function MTZ_82:update(dt)

		if InputBinding.hasEvent(InputBinding.ventelator) then
		   	if self.vent == false then
		   	   self.vent = true
		   	else
		   		self.vent = false
		   	end;
		end;

		if self.vent == false then
	self.ventelatorSpeed = 10;
		end;
		
		if self.vent == true then
	self.ventelatorSpeed = 0;
		end;

		local doRotate = self.armDownMax or self.armDownMin 
		if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
		end;

		local doRotate = self.armUpMax or self.armUpMin 
		if self.armUp ~= nil and doRotate then
			local x, y, z = getRotation(self.armUp.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
			setRotation(self.armUp.node, unpack(newRot));
		end;

		local doRotate = self.rotBraceMax or self.rotBraceMin 
		if self.rotBrace ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
			setRotation(self.rotBrace.node, unpack(newRot));
		end;

		local doRotate = self.rotBrace2Max or self.rotBrace2Min 
		if self.rotBrace2 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace2.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace2.maxRot, self.rotBrace2.minRot, 3, self.rotBrace2.rotTime, dt, not self.rotBrace2Max);
			setRotation(self.rotBrace2.node, unpack(newRot));
		end;
		
		local doTranslate = self.braceVertMax or self.braceVertMin 
		if self.braceVert ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.braceVert.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.braceVert.maxTrans, self.braceVert.minTrans, 3, self.braceVert.transTime, dt, not self.braceVertMax); 
			setTranslation(self.braceVert.node, unpack(newTrans)); 
		end;

         if self:getIsActiveForInput() and self:getIsActiveForSound() and self.DoorPanel then
             if not self.doorsoSoundPlaying then 
              setSamplePitch(self.doorso, self.doorsoSoundPitchOffset);
              playSample(self.doorso, 1, 1, 0);
               self.doorsoSoundPlaying = true; 
           else 
                stopSample(self. doorsoSound); 
                self.doorsoSoundPlaying = false; 
             end;  
          end;

if self.inrange or self.isEntered then
		if InputBinding.hasEvent(InputBinding.DOOR) then
			self:SetDoorPanel(not self.DoorPanel);
		end;
end;

if self.inrange then
	if InputBinding.hasEvent (InputBinding.KAPOT) then
		self.rotationMaxabl1 = not self.rotationMaxabl1;
	end;
end;

    if self.gang0 and self.isEntered then
			if InputBinding.hasEvent (InputBinding.reduktork) then
		setVisibility(self.nevid, self.drawnevid, true);
		setVisibility(self.nevid1, self.drawnevid1, true);
		self.reduktor = true;
			end;

			if InputBinding.hasEvent (InputBinding.reduktorr) then
		setVisibility(self.nevid, self.drawnevid, false);
		setVisibility(self.nevid1, self.drawnevid1, false);
		self.reduktor = false;
			end;

		if self.reduktor then
			self:setAnimationTime(3, self.animationParts[3].offSet);
		else
			self:setAnimationTime(3, self.animationParts[3].animDuration);
		end;
     end;

		if InputBinding.hasEvent(InputBinding.playanim_PipeDown) and self:getIsActiveForInput() then
			self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet+dt), false);
		elseif InputBinding.hasEvent(InputBinding.playanim_PipeUp) and self:getIsActiveForInput() then
			self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet+dt), false);
		end;

		if InputBinding.hasEvent(InputBinding.playanim_PipeDown1) and self:getIsActiveForInput() then
			self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet+dt), false);
		elseif InputBinding.hasEvent(InputBinding.playanim_PipeUp1) and self:getIsActiveForInput() then
			self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet+dt), false);
		end;


	if self.isEntered then
	end;

	if self.inrange or self.isEntered then
		if self.DoorPanel then
			self:setAnimationTime(2, self.animationParts[2].offSet);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_4"), InputBinding.DOOR);
		else
			self:setAnimationTime(2, self.animationParts[2].animDuration);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_5"), InputBinding.DOOR);
		end;
	end;

	if self.inrange then
		if self.rotationMaxabl1 then
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_6"), InputBinding.KAPOT);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_7"), InputBinding.KAPOT);
		end;
	end;
	
	    if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
    
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
        
	    if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;
        if self.rotationParthidra1 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra1.maxRot, self.rotationParthidra1.minRot, 3, self.rotationParthidra1.rotTime, dt, not self.rotationMaxhidra1);
		   setRotation(self.rotationParthidra1.node, unpack(newRot));
        end;
        if self.rotationParthidra2 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra2.maxRot, self.rotationParthidra2.minRot, 3, self.rotationParthidra2.rotTime, dt, not self.rotationMaxhidra2);
		   setRotation(self.rotationParthidra2.node, unpack(newRot));
        end;
        if self.rotationParthidra3 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra3.maxRot, self.rotationParthidra3.minRot, 3, self.rotationParthidra3.rotTime, dt, not self.rotationMaxhidra3);
		   setRotation(self.rotationParthidra3.node, unpack(newRot));
	
	
	    if self.isEntered then
        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
	    
		if self.isEntered then
		  if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
		for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
		end;
	end;
	end;
	end;
	
		if self.isEntered then
        if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    if not self.farlightsActive then
		for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
		end;
	end;
 end;
 
        if self.isEntered then
          if self.frontlightsActive then
            setVisibility(self.frontlights.outs, false);
          else
            setVisibility(self.frontlights.outs, true);
          end;
        end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
		  
        if self.hornPlaying then
            playSample(self.hornSoundId, 1, 0.5, 0);
        else
            stopSample(self.hornSoundId);
        end;

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
    
	end;
	
	
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------

end;

function MTZ_82:updateTick(dt)

					if self.ventelator ~= nil then
					rotate(self.ventelator, self.ventelatorSpeed, 0, 0);
				end;

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;

if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function MTZ_82:draw()
end;

function MTZ_82:SetDoorPanel(isDoorPanel,noEventSend)
	SetDoorPanelEvent.sendEvent(self, isDoorPanel, noEventSend);
	if isDoorPanel then
		self.DoorPanel = true;
	else
		self.DoorPanel = false;
	end;
end;

function MTZ_82:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function MTZ_82:onLeave()
	self.ventelatorSpeed = 0;
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
		self.DoorPanel = false;
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    self.worklightsActive = false;
	
	if self.doorsoSound ~= nil then
        stopSample(self.doorsoSound);
    end;
	
end;

function MTZ_82:delete()   
end;


function MTZ_82:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

function MTZ_82:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

