--
-- MTZRemont
-- Specialization for MTZRemont
--
-- @author  Knagsted
-- @date  16/07/10
--

-- Do not edit without my permission
--
MTZRemont = {};

function MTZRemont.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MTZRemont:load(xmlFile)
	
	self.particleSystemsPar = {};
    local particleSystemsParCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsPar#count"), 0);
    for i=1, particleSystemsParCount do
        local namei = string.format("vehicle.particleSystemsPar.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsPar, namei, nodei, false, nil, self.baseDirectory)			
    end;

		local translationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation5#index"));
      if translationNode5 ~= nil then
        self.translation5 = {};
        self.translation5.node = translationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#minTrans"));
        self.translation5.minTrans = {};
        self.translation5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#maxTrans"));
        self.translation5.maxTrans = {};
        self.translation5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation5#transTime"), 2)*1000;
        self.translation5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation5#touchTransLimit"), 10);
    end;
	
	
	    self.czas1 = 0;
	    self.czas2 = 0;
	    self.czas3 = 0;
	    self.czas4 = 0;
	    self.czas5 = 0;
	    self.czas6 = 0;
	    self.czas7 = 0;
		self.czas15 = 0;
		self.Ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ventelator1#index"));
		self.Ventelator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ventelator#index"));
		self.Kanistra = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Kanistra#index"));
	    self.KanistraActive = true;
	    self.VentelatorActive = true;
	    self.Ventelator1Active = false;
	
end;

function MTZRemont:delete()
end;

function MTZRemont:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MTZRemont:keyEvent(unicode, sym, modifier, isDown)
end;

function MTZRemont:update(dt)

      local speed = self.lastSpeed*3600;
if self.isEntered  then
        if self.czas3 <= 1000100000 and speed >= 10  then
   self.czas3 = self.czas3 +(dt/1);
 end;
 end;
  if self.czas3 >= 2000000 then
	self.Breakdown = true;
	Utils.setEmittingState(self.particleSystemsPar, true);
   	self.VentelatorActive = false;
   	self.Ventelator1Active = true;
  	self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
							local x, y, z = getTranslation(self.translation5.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation5.minTrans, self.translation5.maxTrans, 3, self.translation5.transTime, dt, not self.translation5Min); 
		setTranslation(self.translation5.node, unpack(newTrans)); 
		   	self.czas5 = 1;
  end;
	
	if self.czas5 == 1 and self.inrange and InputBinding.hasEvent (InputBinding.kanistra) then
	 	 self.KanistraActive = false;
		 self.czas7 = 1;
		 end;
		 
  if self.czas7 == 1 and  self.inrange and InputBinding.hasEvent (InputBinding.Kapot) then
	   self.czas2 = 1;

   end;
 if self.czas2 == 1 and self.inrange and InputBinding.hasEvent (InputBinding.zapravka) then
 	  	self.motor.backwardGearRatio = 1;
		self.motor.forwardGearRatios = {2, 2, 2};
				local x, y, z = getTranslation(self.translation5.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation5.maxTrans, self.translation5.minTrans, 3, self.translation5.transTime, dt, not self.translation5Max); 
		setTranslation(self.translation5.node, unpack(newTrans)); 
 	self.czas4 = 1;
   	 self.VentelatorActive = true;
   	 self.Ventelator1Active = false;
   	 self.KanistraActive = true;
	 Utils.setEmittingState(self.particleSystemsPar, false);
 
end;
 if self.czas4 == 1 then
  self.czas3 = 0;
   	self.czas4 = 0;
	   	self.czas5 = 0;
		   	self.czas2 = 0;
			 	self.czas7 = 0;
 end;
  setVisibility(self.Kanistra, self.KanistraActive);
  setVisibility(self.Ventelator1, self.Ventelator1Active);
  setVisibility(self.Ventelator, self.VentelatorActive);
end;

function MTZRemont:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 5.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;

        if self.isClient then
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;

function MTZRemont:onLeave()
end;

function MTZRemont:draw()

	if self.czas3 >= 2000000 then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "DO GONYALSA!!!");
		end;
	end;
end;

