 

MTZ1025 = {};

function MTZ1025.prerequisitesPresent(specializations)
    Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MTZ1025:load(xmlFile)

local rotationPartNodeklavisha = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klavisha#index"));

    if rotationPartNodeklavisha ~= nil then
        self.rotationPartklavisha = {};
        self.rotationPartklavisha.node = rotationPartNodeklavisha;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha#minRot"));
        self.rotationPartklavisha.minRot = {};
        self.rotationPartklavisha.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha#maxRot"));
        self.rotationPartklavisha.maxRot = {};
        self.rotationPartklavisha.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklavisha.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha#rotTime"), 2)*1000;
        self.rotationPartklavisha.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha#touchRotLimit"), 10));
    end;

local rotationPartNodeklavisha1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klavisha1#index"));

    if rotationPartNodeklavisha1 ~= nil then
        self.rotationPartklavisha1 = {};
        self.rotationPartklavisha1.node = rotationPartNodeklavisha1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha1#minRot"));
        self.rotationPartklavisha1.minRot = {};
        self.rotationPartklavisha1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha1#maxRot"));
        self.rotationPartklavisha1.maxRot = {};
        self.rotationPartklavisha1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklavisha1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha1#rotTime"), 2)*1000;
        self.rotationPartklavisha1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha1#touchRotLimit"), 10));
    end;

local rotationPartNodeklavisha2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klavisha2#index"));

    if rotationPartNodeklavisha2 ~= nil then
        self.rotationPartklavisha2 = {};
        self.rotationPartklavisha2.node = rotationPartNodeklavisha2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha2#minRot"));
        self.rotationPartklavisha2.minRot = {};
        self.rotationPartklavisha2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha2#maxRot"));
        self.rotationPartklavisha2.maxRot = {};
        self.rotationPartklavisha2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklavisha2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha2#rotTime"), 2)*1000;
        self.rotationPartklavisha2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha2#touchRotLimit"), 10));
    end;

local rotationPartNodeklavisha3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klavisha3#index"));

    if rotationPartNodeklavisha3 ~= nil then
        self.rotationPartklavisha3 = {};
        self.rotationPartklavisha3.node = rotationPartNodeklavisha3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha3#minRot"));
        self.rotationPartklavisha3.minRot = {};
        self.rotationPartklavisha3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha3#maxRot"));
        self.rotationPartklavisha3.maxRot = {};
        self.rotationPartklavisha3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklavisha3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha3#rotTime"), 2)*1000;
        self.rotationPartklavisha3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha3#touchRotLimit"), 10));
    end;

local rotationPartNodeklavisha4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klavisha4#index"));

    if rotationPartNodeklavisha4 ~= nil then
        self.rotationPartklavisha4 = {};
        self.rotationPartklavisha4.node = rotationPartNodeklavisha4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha4#minRot"));
        self.rotationPartklavisha4.minRot = {};
        self.rotationPartklavisha4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klavisha4#maxRot"));
        self.rotationPartklavisha4.maxRot = {};
        self.rotationPartklavisha4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklavisha4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklavisha4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklavisha4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha4#rotTime"), 2)*1000;
        self.rotationPartklavisha4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klavisha4#touchRotLimit"), 10));
    end;

    self.Vozduhan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Vozduhan#index"));
    self.Vozduhan1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Vozduhan1#index"));
    self.VozduhanActive = true;
    self.Vozduhan1Active = false;

	-- Front wiper animation
	local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperFront#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
        end;
    end;

	self.isWiperFrontActive = false;
	self.finishWiperFront = true;

	-- Rear wiper animation
	local wiperBackAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperBack#rootNode"));
    self.wiperBackAnimCharSet = 0;
    if wiperBackAnimRootNode ~= nil and wiperBackAnimRootNode ~= 0 then
        self.wiperBackAnimCharSet = getAnimCharacterSet(wiperBackAnimRootNode);
        if self.wiperBackAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperBackAnimCharSet, getXMLString(xmlFile, "vehicle.wiperBack#clip"));
            assignAnimTrackClip(self.wiperBackAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperBackAnimCharSet, 0, true);
            local wiperBackAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperBack#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperBackAnimCharSet, 0, wiperBackAnimSpeedScale);
            self.wiperBackAnimDuration = getAnimClipDuration(self.wiperBackAnimCharSet, clip);
        end;
    end;
	self.isWiperBackActive = false;
	self.finishWiperBack = true;
	self.wiperFrontOn = false;
	self.wiperBackOn = false;
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
    self.kardanNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kardan#index"));
    
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 400);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1300);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2000);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	
	self.Temperatura = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Temperatura#index"));
	
	self.VozduhL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.VozduhL#index"));
	
	self.VozduhR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.VozduhR#index"));
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOne#count"), 0);
	self.digitSPEEDOne = {};
    for i=1, self.numDigitSPEEDOne do
        local objname = string.format("vehicle.displayDigitSPEEDOne.digitSPEED" .. "%d", i);
		self.digitSPEEDOne[i] = {};
        self.digitSPEEDOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOne[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOne[self.numDigitSPEEDOne].rotNode,true);
	
	self.numDigitSPEEDTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwo#count"), 0);
	self.digitSPEEDTwo = {};
    for i=1, self.numDigitSPEEDTwo do
        local objname = string.format("vehicle.displayDigitSPEEDTwo.digitSPEED" .. "%d", i);
		self.digitSPEEDTwo[i] = {};
        self.digitSPEEDTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwo[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwo[self.numDigitSPEEDTwo].rotNode,true);

	self.numDigitSPEEDThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThree#count"), 0);
	self.digitSPEEDThree = {};
    for i=1, self.numDigitSPEEDThree do
        local objname = string.format("vehicle.displayDigitSPEEDThree.digitSPEED" .. "%d", i);
		self.digitSPEEDThree[i] = {};
        self.digitSPEEDThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThree[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThree[self.numDigitSPEEDThree].rotNode,true);
	
	self.numDigitSPEEDFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDFour#count"), 0);
	self.digitSPEEDFour = {};
    for i=1, self.numDigitSPEEDFour do
        local objname = string.format("vehicle.displayDigitSPEEDFour.digitSPEED" .. "%d", i);
		self.digitSPEEDFour[i] = {};
        self.digitSPEEDFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDFour[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDFour[self.numDigitSPEEDFour].rotNode,true);
	
	-- Digital display ligth on
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOneLight#count"), 0);
	self.digitSPEEDOneLight = {};
    for i=1, self.numDigitSPEEDOneLight do
        local objname = string.format("vehicle.displayDigitSPEEDOneLight.digitSPEED" .. "%d", i);
		self.digitSPEEDOneLight[i] = {};
        self.digitSPEEDOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOneLight[self.numDigitSPEEDOneLight].rotNode,true);
	
	self.numDigitSPEEDTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwoLight#count"), 0);
	self.digitSPEEDTwoLight = {};
    for i=1, self.numDigitSPEEDTwoLight do
        local objname = string.format("vehicle.displayDigitSPEEDTwo.digitSPEED" .. "%d", i);
		self.digitSPEEDTwoLight[i] = {};
        self.digitSPEEDTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwoLight[self.numDigitSPEEDTwoLight].rotNode,true);

	self.numDigitSPEEDThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThreeLight#count"), 0);
	self.digitSPEEDThreeLight = {};
    for i=1, self.numDigitSPEEDThreeLight do
        local objname = string.format("vehicle.displayDigitSPEEDThreeLight.digitSPEED" .. "%d", i);
		self.digitSPEEDThreeLight[i] = {};
        self.digitSPEEDThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThreeLight[self.numDigitSPEEDThreeLight].rotNode,true);
	
	self.numDigitSPEEDFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDFourLight#count"), 0);
	self.digitSPEEDFourLight = {};
    for i=1, self.numDigitSPEEDFourLight do
        local objname = string.format("vehicle.displayDigitSPEEDFourLight.digitSPEED" .. "%d", i);
		self.digitSPEEDFourLight[i] = {};
        self.digitSPEEDFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDFourLight[self.numDigitSPEEDFourLight].rotNode,true);

	local armHydrNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armHydr#index"));
    if armHydrNode ~= nil then
        self.armHydr = {};
        self.armHydr.node = armHydrNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#minRot"));
        self.armHydr.minRot = {};
        self.armHydr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#maxRot"));
        self.armHydr.maxRot = {};
        self.armHydr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#nullRot"));
        self.armHydr.nullRot = {};
        self.armHydr.nullRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.nullRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.nullRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armHydr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armHydr#rotTime"), 2)*1000;
        self.armHydr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armHydr#touchRotLimit"), 10));
    end;

local rotationPartNodekorobka0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka0#index"));
    if rotationPartNodekorobka0 ~= nil then
        self.rotationPartkorobka0 = {};
        self.rotationPartkorobka0.node = rotationPartNodekorobka0;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka0#minRot"));
        self.rotationPartkorobka0.minRot = {};
        self.rotationPartkorobka0.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka0.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka0.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka0#maxRot"));
        self.rotationPartkorobka0.maxRot = {};
        self.rotationPartkorobka0.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka0.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka0.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka0.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka0#rotTime"), 2)*1000;
        self.rotationPartkorobka0.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka0#touchRotLimit"), 10));
    end;
 local rotationPartNodekorobka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka#index"));
    if rotationPartNodekorobka ~= nil then
        self.rotationPartkorobka = {};
        self.rotationPartkorobka.node = rotationPartNodekorobka;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka#minRot"));
        self.rotationPartkorobka.minRot = {};
        self.rotationPartkorobka.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka#maxRot"));
        self.rotationPartkorobka.maxRot = {};
        self.rotationPartkorobka.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka#rotTime"), 2)*1000;
        self.rotationPartkorobka.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka#touchRotLimit"), 10));
    end;
	local rotationPartNodekorobka1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka1#index"));
    if rotationPartNodekorobka1 ~= nil then
        self.rotationPartkorobka1 = {};
        self.rotationPartkorobka1.node = rotationPartNodekorobka1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka1#minRot"));
        self.rotationPartkorobka1.minRot = {};
        self.rotationPartkorobka1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka1#maxRot"));
        self.rotationPartkorobka1.maxRot = {};
        self.rotationPartkorobka1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka1#rotTime"), 2)*1000;
        self.rotationPartkorobka1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka1#touchRotLimit"), 10));
    end;
	local rotationPartNodekorobka2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka2#index"));
    if rotationPartNodekorobka2 ~= nil then
        self.rotationPartkorobka2 = {};
        self.rotationPartkorobka2.node = rotationPartNodekorobka2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka2#minRot"));
        self.rotationPartkorobka2.minRot = {};
        self.rotationPartkorobka2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka2#maxRot"));
        self.rotationPartkorobka2.maxRot = {};
        self.rotationPartkorobka2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka2#rotTime"), 2)*1000;
        self.rotationPartkorobka2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka2#touchRotLimit"), 10));
    end;	
local rotationPartNodekorobka3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka3#index"));
    if rotationPartNodekorobka3 ~= nil then
        self.rotationPartkorobka3 = {};
        self.rotationPartkorobka3.node = rotationPartNodekorobka3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka3#minRot"));
        self.rotationPartkorobka3.minRot = {};
        self.rotationPartkorobka3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka3#maxRot"));
        self.rotationPartkorobka3.maxRot = {};
        self.rotationPartkorobka3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka3#rotTime"), 2)*1000;
        self.rotationPartkorobka3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka3#touchRotLimit"), 10));
    end;		
	local rotationPartNodekorobka4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobka4#index"));
    if rotationPartNodekorobka4 ~= nil then
        self.rotationPartkorobka4 = {};
        self.rotationPartkorobka4.node = rotationPartNodekorobka4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobka4#minRot"));
        self.rotationPartkorobka4.minRot = {};
        self.rotationPartkorobka4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobka4#maxRot"));
        self.rotationPartkorobka4.maxRot = {};
        self.rotationPartkorobka4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobka4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobka4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobka4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka4#rotTime"), 2)*1000;
        self.rotationPartkorobka4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobka4#touchRotLimit"), 10));
    end;
	local rotationPartNodekorobkazad = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.korobkazad#index"));
    if rotationPartNodekorobkazad ~= nil then
        self.rotationPartkorobkazad = {};
        self.rotationPartkorobkazad.node = rotationPartNodekorobkazad;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkorobkazad#minRot"));
        self.rotationPartkorobkazad.minRot = {};
        self.rotationPartkorobkazad.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobkazad.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobkazad.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korobkazad#maxRot"));
        self.rotationPartkorobkazad.maxRot = {};
        self.rotationPartkorobkazad.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkorobkazad.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkorobkazad.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkorobkazad.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobkazad#rotTime"), 2)*1000;
        self.rotationPartkorobkazad.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.korobkazad#touchRotLimit"), 10));
    end;

local rotationPartNodeTahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTahometr#index"));
    if rotationPartNodeTahometr ~= nil then
        self.rotationPartTahometr = {};
        self.rotationPartTahometr.node = rotationPartNodeTahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#minRot"));
        self.rotationPartTahometr.minRot = {};
        self.rotationPartTahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#maxRot"));
        self.rotationPartTahometr.maxRot = {};
        self.rotationPartTahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#rotTime"), 2)*1000;
        self.rotationPartTahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#touchRotLimit"), 10));
    end;

local rotationPartNodeGaz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartGaz#index"));
    if rotationPartNodeGaz ~= nil then
        self.rotationPartGaz = {};
        self.rotationPartGaz.node = rotationPartNodeGaz;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGaz#minRot"));
        self.rotationPartGaz.minRot = {};
        self.rotationPartGaz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGaz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGaz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGaz#maxRot"));
        self.rotationPartGaz.maxRot = {};
        self.rotationPartGaz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGaz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGaz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartGaz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGaz#rotTime"), 2)*1000;
        self.rotationPartGaz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGaz#touchRotLimit"), 10));
    end;

local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
      
    self.VomNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Vom#index"));
    self.backcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backcamera#index"));
    self.help = false;
	
    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;
	
    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local cylinder1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder1#index"));
    if cylinder1Node ~= nil then
        self.cylinder1 = {};
        self.cylinder1.node = cylinder1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#minRot"));
        self.cylinder1.minRot = {};
        self.cylinder1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#maxRot"));
        self.cylinder1.maxRot = {};
        self.cylinder1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cylinder1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#rotTime"), 2)*1000;
        self.cylinder1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#touchRotLimit"), 10));
    end;

    local cylinder2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder2#index"));
    if cylinder2Node ~= nil then
        self.cylinder2 = {};
        self.cylinder2.node = cylinder2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#minTrans"));
        self.cylinder2.minTrans = {};
        self.cylinder2.minTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.minTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#maxTrans"));
        self.cylinder2.maxTrans = {};
        self.cylinder2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.cylinder2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#transTime"), 2)*1000;
        self.cylinder2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#touchTransLimit"), 10);
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;
    self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
    self.motorBrakeForce = self.motor.brakeForce;
	
	self.prevousDigitSPEEDFour = self.numDigitSPEEDFour;
	self.prevousDigitSPEEDThree = self.numDigitSPEEDThree;
	self.prevousDigitSPEEDTwo = self.numDigitSPEEDTwo;
	self.prevousDigitSPEEDOne = self.numDigitSPEEDOne;
	self.speedDisplaysSetOff = false;


end;

function MTZ1025:delete()
   
end;


function MTZ1025:mouseEvent(posX, posY, isDown, isUp, button)

end;

function MTZ1025:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_pageup  then
	self.armDownMax = isDown;
	self.armUpMax = isDown;
	self.cylinder1Max = isDown;
	self.rotBraceMax = isDown;
	self.cylinder2Max = isDown;
	self.armHydrMax = isDown;
	self.armMax = true;
	self.armMin = false;
	self.armDownMin = false;
	self.armUpMin = false;
	self.cylinder1Min = false;
	self.rotBraceMin = false;
	self.cylinder2Min = false;
	self.armHydrMin = false;
        local x, y, z = getRotation(self.armDown.node);
	if x >= self.armDown.maxRot[1]-0.03 then
	      if self.selectedImplement ~= 0 then
	          local implement = self.attachedImplements[self.selectedImplement];
	          local jointDesc = self.attacherJoints[implement.jointDescIndex];
	          self:setJointMoveDown(implement.jointDescIndex, false, false);
	      end;
	end;		
    end;

    if sym == Input.KEY_pagedown then
	self.armDownMin = isDown;
	self.armUpMin = isDown;
	self.cylinder1Min = isDown;
	self.rotBraceMin = isDown;
	self.cylinder2Min = isDown;
	self.armHydrMin = isDown;
	self.armDownMax = false;
	self.armUpMax = false;
	self.cylinder1Max = false;
	self.rotBraceMax = false;
	self.cylinder2Max = false;
	self.armHydrMax = false;
        local x, y, z = getRotation(self.armDown.node);
	if x <= self.armDown.minRot[1]+0.03 then
	      if self.selectedImplement ~= 0 then
	          local implement = self.attachedImplements[self.selectedImplement];
	          local jointDesc = self.attacherJoints[implement.jointDescIndex];
	          self:setJointMoveDown(implement.jointDescIndex, true, true);
	      end;
	end;
    end;

    if isDown and sym == Input.KEY_0 then
	self.help = not self.help;
    end;

	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
end;


function MTZ1025:update(dt)

if self.isMotorStarted then
	if self.kardanNode ~= nil then
         	rotate(self.kardanNode, 0, 0, self.wheelRpm*0.01*self.movingDirection);
	end;
end;
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	if self.isMotorStarted then
		   setRotation(self.Temperatura, 0, 60, 0);
		   setRotation(self.VozduhL, 0, -80, 0);
		   setRotation(self.VozduhR, 0, 80, 0);
	end;
	
	-- Digital Display handling Speed
	if self.isMotorStarted then
		--if self.displaySelectorMode == 0 then
		
		--end;
		local displayValueSpeed = math.floor(self.lastSpeed * 3600 * 100);
		displayValueSpeed = displayValueSpeed/10;
		
		--if self.displaySelectorMode == 1 then
			--displayValueSpeed = math.floor(displayValueSpeed);
		--end;

		-- Handle the digitSPEEDs in the display
		if self.isMotorStarted then
			setVisibility(self.digitSPEEDTwo[11].rotNode,true);
			local thousends = math.floor(displayValueSpeed/1000);
			local displayIndex = thousends;
			if self.prevousDigitSPEEDFour ~= thousends then
				if self.prevousDigitSPEEDFour > 0 then
					setVisibility(self.digitSPEEDFour[self.prevousDigitSPEEDFour].rotNode,false);
					setVisibility(self.digitSPEEDFourLight[self.prevousDigitSPEEDFour].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitSPEEDFour; 
				end;
				setVisibility(self.digitSPEEDFour[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDFourLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDFour = displayIndex;
				
			displayValueSpeed = displayValueSpeed - thousends * 1000;
			local hundreds = math.floor(displayValueSpeed/100);
			displayIndex = hundreds;
			if self.prevousDigitSPEEDThree ~= hundreds then
				if self.prevousDigitSPEEDThree > 0 then
					setVisibility(self.digitSPEEDThree[self.prevousDigitSPEEDThree].rotNode,false);
					setVisibility(self.digitSPEEDThreeLight[self.prevousDigitSPEEDThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					displayIndex = self.numDigitSPEEDThree;
				elseif displayIndex == 0 then 
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDThree[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDThreeLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDThree = displayIndex;
			
			displayValueSpeed = displayValueSpeed - hundreds * 100;
			local tens = math.floor(displayValueSpeed/10);
			displayIndex = tens;
			if self.prevousDigitSPEEDTwo ~= tens then
				if self.prevousDigitSPEEDTwo > 0 then
					setVisibility(self.digitSPEEDTwo[self.prevousDigitSPEEDTwo].rotNode,false);
					setVisibility(self.digitSPEEDTwoLight[self.prevousDigitSPEEDTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					displayIndex = 10;
				elseif displayIndex == 0 then 
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDTwo[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDTwoLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDTwo = displayIndex;
			
			displayValueSpeed = displayValueSpeed - tens * 10;
			local ones = math.floor(displayValueSpeed);
			displayIndex = ones;
			if self.prevousDigitSPEEDOne ~= ones then
				if self.prevousDigitSPEEDOne > 0 then
					setVisibility(self.digitSPEEDOne[self.prevousDigitSPEEDOne].rotNode,false);
					setVisibility(self.digitSPEEDOneLight[self.prevousDigitSPEEDOne].rotNode,false);
				end;

				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitSPEEDOne[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDOne = displayIndex;
			self.speedDisplaysSetOff = false;
		else
			if not self.speedDisplaysSetOff then
				for i=1, self.numDigitSPEEDOne do
					setVisibility(self.digitSPEEDOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwo do
					setVisibility(self.digitSPEEDTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThree do
					setVisibility(self.digitSPEEDThree[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDFour do
					setVisibility(self.digitSPEEDFour[i].rotNode,false);
				end;
				
				for i=1, self.numDigitSPEEDOneLight do
					setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwoLight do
					setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThreeLight do
					setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDFourLight do
					setVisibility(self.digitSPEEDFourLight[i].rotNode,false);
				end;
				self.speedDisplaysSetOff = true;
			end;
		end;
	end;

    if self.isAITractorActivated then
		if self.turnStage == 0 then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.cylinder2Max = false;
	        self.armHydrMax = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.cylinder2Min = false;
	        self.armHydrMin = false;
		end;
    elseif self:getIsActiveForInput() and self.isEntered then

        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
		if not self.armDownMax then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.cylinder2Min = false;
	        self.armHydrMin = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.cylinder2Max = false;
	        self.armHydrMax = false;
		end;
        end;

	if InputBinding.hasEvent(InputBinding.ATTACH) then
		if not self.armDownMax then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.cylinder2Min = false;
	        self.armHydrMin = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.cylinder2Max = false;
	        self.armHydrMax = false;
		end;
	end;
    end;

if  self.armHydr ~= nil and not self.armHydrMax and not self.armHydrMin  then
	setRotation(self.armHydr.node, 0, 0, 0);
end;

if self.motor.lastMotorRpm > 300 and self.motor.lastMotorRpm < 650 then
self.rotationMaxkorobka = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobkazad = false;
	end;
if self.motor.lastMotorRpm > 650 and self.motor.lastMotorRpm < 700 then
self.rotationMaxkorobka = false;
self.rotationMaxkorobka1 = false;
self.rotationMaxkorobka0 = true;
self.rotationMaxkorobkazad = false;
	end;	
	
if self.motor.lastMotorRpm > 700 and self.motor.lastMotorRpm < 1050 then
self.rotationMaxkorobka1 = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobkazad = false;
	end;

if self.motor.lastMotorRpm > 1050 and self.motor.lastMotorRpm < 1100 then
self.rotationMaxkorobka1 = false;
self.rotationMaxkorobka2 = false;
self.rotationMaxkorobka0 = true;
self.rotationMaxkorobkazad = false;
	end;
	
if self.motor.lastMotorRpm > 1100 and self.motor.lastMotorRpm < 1450 then
self.rotationMaxkorobka2 = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobkazad = false;
	end;
if self.motor.lastMotorRpm > 1450 and self.motor.lastMotorRpm < 1500 then
self.rotationMaxkorobka2 = false;
self.rotationMaxkorobka3 = false;
self.rotationMaxkorobka0 = true;
self.rotationMaxkorobkazad = false;
	end;

	
if self.motor.lastMotorRpm > 1500 and self.motor.lastMotorRpm < 1950 then
self.rotationMaxkorobka3 = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobkazad = false;
	end;	
if self.motor.lastMotorRpm > 1950 and self.motor.lastMotorRpm < 2000 then
self.rotationMaxkorobka3 = false;
self.rotationMaxkorobka4 = false;
self.rotationMaxkorobka0 = true;
self.rotationMaxkorobkazad = false;
	end;	
if self.motor.lastMotorRpm > 2000 then
self.rotationMaxkorobka4 = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobkazad = false;
	end;	
if self.brakeSoundAllow then
self.rotationMaxkorobkazad = true;
self.rotationMaxkorobka0 = false;
self.rotationMaxkorobka = false;
self.rotationMaxkorobka1 = false;
self.rotationMaxkorobka2 = false;
self.rotationMaxkorobka3 = false;
self.rotationMaxkorobka4 = false;
	end;		
	
	
 if self.motor.lastMotorRpm < 300 then
self.rotationMaxkorobka0 = true;
self.rotationMaxkorobka = false;
self.rotationMaxkorobka1 = false;
self.rotationMaxkorobka2 = false;
self.rotationMaxkorobka3 = false;
self.rotationMaxkorobka4 = false;
self.rotationMaxkorobkazad = false;
	end;
	
	
if self.rotationMaxkorobka0 == true then
if self.rotationPartkorobka0 ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka0.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka0.maxRot, self.rotationPartkorobka0.minRot, 3, self.rotationPartkorobka0.rotTime, dt, not self.rotationMaxkorobka0);
		   setRotation(self.rotationPartkorobka0.node, unpack(newRot));
       end;
	   end;

if self.rotationMaxkorobka == true then
if self.rotationPartkorobka ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka.maxRot, self.rotationPartkorobka.minRot, 3, self.rotationPartkorobka.rotTime, dt, not self.rotationMaxkorobka);
		   setRotation(self.rotationPartkorobka.node, unpack(newRot));
       end;
	   end;
if self.rotationMaxkorobka1 == true then	   
if self.rotationPartkorobka1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka1.maxRot, self.rotationPartkorobka1.minRot, 3, self.rotationPartkorobka1.rotTime, dt, not self.rotationMaxkorobka1);
		   setRotation(self.rotationPartkorobka1.node, unpack(newRot));
       end;
end;
if self.rotationMaxkorobka2 == true then
if self.rotationPartkorobka2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka2.maxRot, self.rotationPartkorobka2.minRot, 3, self.rotationPartkorobka2.rotTime, dt, not self.rotationMaxkorobka2);
		   setRotation(self.rotationPartkorobka2.node, unpack(newRot));
       end;
end;
 
if self.rotationMaxkorobka3 == true then
if self.rotationPartkorobka3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka3.maxRot, self.rotationPartkorobka3.minRot, 3, self.rotationPartkorobka3.rotTime, dt, not self.rotationMaxkorobka3);
		   setRotation(self.rotationPartkorobka3.node, unpack(newRot));
       end;
end;

if self.rotationMaxkorobka4 == true then
if self.rotationPartkorobka4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobka4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobka4.maxRot, self.rotationPartkorobka4.minRot, 3, self.rotationPartkorobka4.rotTime, dt, not self.rotationMaxkorobka4);
		   setRotation(self.rotationPartkorobka4.node, unpack(newRot));
       end;
end;
if self.rotationMaxkorobkazad == true then
if self.rotationPartkorobkazad ~= nil then
		   local x, y, z = getRotation(self.rotationPartkorobkazad.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkorobkazad.maxRot, self.rotationPartkorobkazad.minRot, 3, self.rotationPartkorobkazad.rotTime, dt, not self.rotationMaxkorobkazad);
		   setRotation(self.rotationPartkorobkazad.node, unpack(newRot));
       end;
end;

if self.inrange or self.isEntered then
	if InputBinding.isPressed(InputBinding.PRAVAYDVER) then
		if self.animationParts[1].clipEndTime then
				
			self:setAnimationTime(1, self.animationParts[1].offSet);

		elseif self.animationParts[1].clipStartTime then
				
			self:setAnimationTime(1, self.animationParts[1].animDuration);
		end;
	end;
	if InputBinding.isPressed(InputBinding.LEVAYDVER) then
		if self.animationParts[2].clipEndTime then
				
			self:setAnimationTime(2, self.animationParts[2].offSet);

		elseif self.animationParts[2].clipStartTime then
				
			self:setAnimationTime(2, self.animationParts[2].animDuration);
		end;
	end;
end;

if self.isEntered then
	if InputBinding.isPressed(InputBinding.Rucnick) then  
		if self.animationParts[11].clipEndTime then
		    self.Breakdown = true;
			self:setAnimationTime(11, self.animationParts[11].offSet);
		elseif self.animationParts[11].clipStartTime then
			self:setAnimationTime(11, self.animationParts[11].animDuration);
		    self.Breakdown = false;
		end;
	end;
	if InputBinding.isPressed(InputBinding.PravoeSteclo) then
		if self.animationParts[3].clipEndTime then
				
			self:setAnimationTime(3, self.animationParts[3].offSet);

		elseif self.animationParts[3].clipStartTime then
				
			self:setAnimationTime(3, self.animationParts[3].animDuration);
		end;
	end;
	if InputBinding.isPressed(InputBinding.LevoeSteclo) then
		if self.animationParts[4].clipEndTime then
				
			self:setAnimationTime(4, self.animationParts[4].offSet);

		elseif self.animationParts[4].clipStartTime then
				
			self:setAnimationTime(4, self.animationParts[4].animDuration);
		end;
	end;
	if InputBinding.isPressed(InputBinding.ZadneeSteclo) then
		if self.animationParts[5].clipEndTime then
				
			self:setAnimationTime(5, self.animationParts[5].offSet);

		elseif self.animationParts[5].clipStartTime then
				
			self:setAnimationTime(5, self.animationParts[5].animDuration);
		end;
	end;
	if InputBinding.isPressed(InputBinding.Luck) then
		if self.animationParts[6].clipEndTime then
				
			self:setAnimationTime(6, self.animationParts[6].offSet);

		elseif self.animationParts[6].clipStartTime then
				
			self:setAnimationTime(6, self.animationParts[6].animDuration);
		end;
	end;
end;

if self.inrange then
	if InputBinding.isPressed(InputBinding.Kapot) then
		if self.animationParts[7].clipEndTime then
				
			self:setAnimationTime(7, self.animationParts[7].offSet);
            self.VozduhanActive = true;
            self.Vozduhan1Active = false;

		elseif self.animationParts[7].clipStartTime then
				
			self:setAnimationTime(7, self.animationParts[7].animDuration);
            self.VozduhanActive = false;
            self.Vozduhan1Active = true;
		end;
	end;
end;

if self:getIsActiveForInput() then
	if InputBinding.isPressed(InputBinding.LOWER_IMPLEMENT) then
		if self.animationParts[9].clipEndTime then
				
			self:setAnimationTime(9, self.animationParts[9].offSet);

		elseif self.animationParts[9].clipStartTime then
				
			self:setAnimationTime(9, self.animationParts[9].animDuration);
		end;
	end;
end;
if self.isMotorStarted then
	self:setAnimationTime(10, 1);
		
else
			
	self:setAnimationTime(10, 0);
		
end;

	if self.rotationPartklavisha1 ~= nil then
		local x, y, z = getRotation(self.rotationPartklavisha1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklavisha1.maxRot, self.rotationPartklavisha1.minRot, 3, self.rotationPartklavisha1.rotTime, dt, not self.rotationMaxklavisha1);
		setRotation(self.rotationPartklavisha1.node, unpack(newRot));
	end;

	if self.rotationPartklavisha ~= nil then
		local x, y, z = getRotation(self.rotationPartklavisha.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklavisha.maxRot, self.rotationPartklavisha.minRot, 3, self.rotationPartklavisha.rotTime, dt, not self.rotationMaxklavisha);
		setRotation(self.rotationPartklavisha.node, unpack(newRot));
	end;

	if self.rotationPartklavisha2 ~= nil then
		local x, y, z = getRotation(self.rotationPartklavisha2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklavisha2.maxRot, self.rotationPartklavisha2.minRot, 3, self.rotationPartklavisha2.rotTime, dt, not self.rotationMaxklavisha2);
		setRotation(self.rotationPartklavisha2.node, unpack(newRot));
	end;

	if self.rotationPartklavisha3 ~= nil then
		local x, y, z = getRotation(self.rotationPartklavisha3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklavisha3.maxRot, self.rotationPartklavisha3.minRot, 3, self.rotationPartklavisha3.rotTime, dt, not self.rotationMaxklavisha3);
		setRotation(self.rotationPartklavisha3.node, unpack(newRot));
	end;

	if self.rotationPartklavisha4 ~= nil then
		local x, y, z = getRotation(self.rotationPartklavisha4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklavisha4.maxRot, self.rotationPartklavisha4.minRot, 3, self.rotationPartklavisha4.rotTime, dt, not self.rotationMaxklavisha4);
		setRotation(self.rotationPartklavisha4.node, unpack(newRot));
	end;

	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;

	local maxrotationPartTahometr = 2000;
	if self.rotationPartTahometr ~= nil then
		local x, y, z = getRotation(self.rotationPartTahometr.node);
		y = ((self.rotationPartTahometr.maxRot[2] - self.rotationPartTahometr.minRot[2]) / maxrotationPartTahometr) * self.motor.lastMotorRpm + self.rotationPartTahometr.minRot[2];
		setRotation(self.rotationPartTahometr.node, x, y ,z);
	end;

	local maxrotationPartGaz = 2000;
	if self.rotationPartGaz ~= nil then
		local x, y, z = getRotation(self.rotationPartGaz.node);
		y = ((self.rotationPartGaz.maxRot[2] - self.rotationPartGaz.minRot[2]) / maxrotationPartGaz) * self.motor.lastMotorRpm + self.rotationPartGaz.minRot[2];
		setRotation(self.rotationPartGaz.node, x, y ,z);
	end;


    if self.isEntered then
        if Input.isKeyPressed(Input.KEY_shift) and self.camIndex == 2 then
                setCamera(self.backcamera);
       	end;
	end;


    if self.isEntered then

	local doRotate = self.armUpMax or self.armUpMin 
	if self.armUp ~= nil and doRotate then
		local x, y, z = getRotation(self.armUp.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
		setRotation(self.armUp.node, unpack(newRot));
	end;
		
	local doRotate = self.armHydrMax or self.armHydrMin 
	if self.armHydr ~= nil and doRotate then
        local x, y, z = getRotation(self.armHydr.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.armHydr.maxRot, self.armHydr.minRot, 3, self.armHydr.rotTime, dt, not self.armHydrMax);
        setRotation(self.armHydr.node, unpack(newRot));
	end;

	local doRotate = self.armDownMax or self.armDownMin 
	if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
	end;

	local doRotate = self.cylinder1Max or self.cylinder1Min 
	if self.cylinder1 ~= nil and doRotate then
		local x, y, z = getRotation(self.cylinder1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.cylinder1.maxRot, self.cylinder1.minRot, 3, self.cylinder1.rotTime, dt, not self.cylinder1Max);
		setRotation(self.cylinder1.node, unpack(newRot));
	end;

	local doTranslate = self.cylinder2Max or self.cylinder2Min 
	if self.cylinder2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.cylinder2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.cylinder2.maxTrans, self.cylinder2.minTrans, 3, self.cylinder2.transTime, dt, not self.cylinder2Max); 
		setTranslation(self.cylinder2.node, unpack(newTrans)); 
	end;

	local doRotate = self.rotBraceMax or self.rotBraceMin 
	if self.rotBrace ~= nil and doRotate then
		local x, y, z = getRotation(self.rotBrace.node);		
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
		setRotation(self.rotBrace.node, unpack(newRot));
	end;
    end;
    setVisibility(self.Vozduhan, self.VozduhanActive);
    setVisibility(self.Vozduhan1, self.Vozduhan1Active);

end;

function MTZ1025:updateTick(dt)

	-- Stop wipers in correct position
	if not self.finishWiperFront then
		if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
			setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.finishWiperFront = true;
		end;
	end;

	if not self.finishWiperBack then
		if getAnimTrackTime(self.wiperBackAnimCharSet, 0) % self.wiperBackAnimDuration <= 100 then
			setAnimTrackTime(self.wiperBackAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.finishWiperBack = true;
		end;
	end;

	-- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperFrontOn then
		if not self.isWiperFrontActive then
			enableAnimTrack(self.wiperFrontAnimCharSet, 0);
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperFrontActive = true;
			self.isWiperBackActive = true;
		end;
		setRotation(self.wiperLever, 0, math.rad(-18), 0);
	else
		if self.isWiperFrontActive then
			self.isWiperFrontActive = false;
			self.finishWiperFront = false;
		end;
		setRotation(self.wiperLever, 0, 0, 0);
	end;

	-- Start rear wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperBackOn then
		if not self.isWiperBackActive then
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperBackActive = true;
		end;
	else
		if self.isWiperBackActive then
			self.isWiperBackActive = false;
			self.finishWiperBack = false;
		end;
	end;
	
    if self:getIsActive() then
		if self.isMotorStarted then
			for k, implement in pairs(self.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn then
						self:setAnimationTime(8, self.animationParts[8].animDuration);
         	            rotate(self.VomNode, 0, 0, self.motor.lastMotorRpm*dt);
					else
						self:setAnimationTime(8, self.animationParts[8].offSet);
					end;
				end;
			end;
		end;
	end;

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 5.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;

        if self.isClient then
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;
function MTZ1025:draw()

	if not self.help then
            renderText(0.1, 0.985, 0.015, "0: Info be");
        else
            renderText(0.1, 0.985, 0.015, "0: Info ki");
        end;
        
        if self.help then
            		renderText(0.02, 0.18, 0.03, "- MTZ1025 Info -");
            		renderText(0.02, 0.22, 0.02, "KP_3: Rpovorot");
			renderText(0.02, 0.24, 0.02, "KP_1: Lpovorot");
			renderText(0.02, 0.26, 0.02, "KP_2: avarika");
			renderText(0.02, 0.28, 0.02, "Numpad 4: dver lev");
			renderText(0.02, 0.30, 0.02, "Numpad 6: dvar prav");
			renderText(0.02, 0.60, 0.02, "Numpad 6: Krisha");
				renderText(0.02, 0.32, 0.02, "n, num_3, m: esli zakipel");
			renderText(0.02, 0.34, 0.02, "Numpad 7: okno lev");
			renderText(0.02, 0.36, 0.02, "Numpad 5: okno zad");
			renderText(0.02, 0.38, 0.02, "Numpad 9: okno prav");
			renderText(0.02, 0.40, 0.02, "Numpad +/-: fordulatszam szabalyzo");
			renderText(0.02, 0.42, 0.02, "Key 7: kapot");
			renderText(0.02, 0.44, 0.02, "PAGEUP/PAGEDOWN: hidraulika fel/le");
            		renderText(0.02, 0.46, 0.02, "F: fenyszoro be/ki");
            		renderText(0.02, 0.48, 0.02, "2xnum_enter: zavesti");
            		renderText(0.02, 0.50, 0.02, "SHIFT: hatranez (belso nezetben)");
            		renderText(0.02, 0.52, 0.02, "BAL EGER/JOBB EGER: valtas fel/le");
            		renderText(0.02, 0.54, 0.02, "HOME/END: felezo orszagut/terep (ures fokozatbol kapcsolhato)");
            		renderText(0.02, 0.56, 0.02, "DELETE: Sebessegvalto panel athelyez");
            		renderText(0.02, 0.58, 0.02, "SPACE: Kuplung");
					
		end;

end;

function MTZ1025:onLeave()
	if self.isWiperFrontActive then
		disableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		disableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
end;

function MTZ1025:onEnter()
	if self.isWiperFrontActive then
		enableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		enableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
end;

function MTZ1025:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;