--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);
	if self.count ~= 0 then
		for i=1, self.count do
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText("ic_button_on");
			local offMessage = g_i18n:getText("ic_button_off");

			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;

end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;

	return instance;
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		self.isOpen = self.vehicle.currentLight == 2;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
	if self.event == "toggleFrontWiper" then
		if self.vehicle ~= nil then
			if self.vehicle.wiperFrontOn then
                self.vehicle.rotationMaxklavisha3 = false;
				self.vehicle.wiperFrontOn = false;
			else
                self.vehicle.rotationMaxklavisha3 = true;
				self.vehicle.wiperFrontOn = true;
			end;
		end;
	end;
	if self.event == "toggleBackWiper" then
		if self.vehicle ~= nil then
			if self.vehicle.wiperBackOn then
                self.vehicle.rotationMaxklavisha4 = false;
				self.vehicle.wiperBackOn = false;
			else
                self.vehicle.rotationMaxklavisha4 = true;
				self.vehicle.wiperBackOn = true;
			end;
		end;
	end;
	if self.event == "toggleFrontlights" then
		if self.vehicle ~= nil then
			if self.vehicle.lightsActive then
                self.vehicle.rotationMaxklavisha2 = false;
				self.vehicle:setLightsVisibility(false);
			else
                self.vehicle.rotationMaxklavisha2 = true;
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "toggleFrontWorklights" then
		if self.vehicle ~= nil then
			local i = 1;
			if self.vehicle.B3.work[i].a then
                self.vehicle.rotationMaxklavisha = false;
				self.vehicle:setState("work:"..i, false);
			else
                self.vehicle.rotationMaxklavisha = true;
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "toggleBackWorklights" then
		if self.vehicle ~= nil then
			local i = 2;
			if self.vehicle.B3.work[i].a then
                self.vehicle.rotationMaxklavisha1 = false;
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
                self.vehicle.rotationMaxklavisha1 = true;
			end;
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;
