SetLeafsDischargeEvent = {};
SetLeafsDischargeEvent_mt = Class(SetLeafsDischargeEvent, Event);

InitEventClass(SetLeafsDischargeEvent, "SetLeafsDischargeEvent");

function SetLeafsDischargeEvent:emptyNew()
    local self = Event:new(SetLeafsDischargeEvent_mt);
    self.className="SetLeafsDischargeEvent";
    return self;
end;

function SetLeafsDischargeEvent:new(vehicle, isDischarge)
    local self = SetLeafsDischargeEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDischarge = isDischarge;
    return self;
end;

function SetLeafsDischargeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDischarge = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLeafsDischargeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDischarge);
end;

function SetLeafsDischargeEvent:run(connection)   
	self.vehicle:setLeafsDischarge(self.isDischarge, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLeafsDischargeEvent:new(self.vehicle, self.isDischarge), nil, connection, self.vehicle);
    end;
end;

function SetLeafsDischargeEvent.sendEvent(vehicle, isDischarge, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLeafsDischargeEvent:new(vehicle, isDischarge), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLeafsDischargeEvent:new(vehicle, isDischarge));
		end;
	end;
end;